/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.socket.starter;

import java.util.List;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.concurrent.counter.CounterManager;
import org.hswebframework.web.message.Messager;
import org.hswebframework.web.socket.WebSocketSessionListener;
import org.hswebframework.web.socket.authorize.AuthorizeCommandProcessor;
import org.hswebframework.web.socket.authorize.SessionIdWebSocketTokenParser;
import org.hswebframework.web.socket.authorize.WebSocketTokenParser;
import org.hswebframework.web.socket.authorize.XAccessTokenParser;
import org.hswebframework.web.socket.handler.CommandWebSocketMessageDispatcher;
import org.hswebframework.web.socket.message.DefaultWebSocketMessager;
import org.hswebframework.web.socket.message.WebSocketMessager;
import org.hswebframework.web.socket.processor.CommandProcessor;
import org.hswebframework.web.socket.processor.CommandProcessorContainer;
import org.hswebframework.web.socket.processor.DefaultCommandProcessorContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketConfigurationSupport;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@Configuration
public class CommandWebSocketAutoConfiguration {
    @Bean
    public SessionIdWebSocketTokenParser sessionIdWebSocketTokenParser() {
        return new SessionIdWebSocketTokenParser();
    }

    @Bean
    public XAccessTokenParser xAccessTokenParser() {
        return new XAccessTokenParser();
    }

    @Bean
    @ConditionalOnBean(value={UserTokenManager.class})
    public AuthorizeCommandProcessor authorizeCommandProcessor(UserTokenManager userTokenManager) {
        return new AuthorizeCommandProcessor(userTokenManager);
    }

    @Bean
    @ConfigurationProperties(prefix="hsweb.websocket")
    public ServletServerContainerFactoryBean createServletServerContainerFactoryBean() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(0xA00000);
        container.setMaxBinaryMessageBufferSize(0xA00000);
        return container;
    }

    @Configuration
    @ConfigurationProperties(prefix="hsweb.websocket")
    public static class HandlerConfiguration
    extends WebSocketConfigurationSupport {
        private String[] allowedOrigins;
        @Autowired(required=false)
        private UserTokenManager userTokenManager;
        @Autowired(required=false)
        private List<WebSocketSessionListener> webSocketSessionListeners;
        @Autowired(required=false)
        private List<WebSocketTokenParser> webSocketTokenParsers;
        @Autowired
        private CommandProcessorContainer commandProcessorContainer;

        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        protected void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
            CommandWebSocketMessageDispatcher dispatcher = new CommandWebSocketMessageDispatcher();
            dispatcher.setProcessorContainer(this.commandProcessorContainer);
            dispatcher.setUserTokenManager(this.userTokenManager);
            dispatcher.setWebSocketSessionListeners(this.webSocketSessionListeners);
            dispatcher.setTokenParsers(this.webSocketTokenParsers);
            registry.addHandler((WebSocketHandler)dispatcher, new String[]{"/sockjs"}).setAllowedOrigins(this.allowedOrigins).withSockJS().setSessionCookieNeeded(true);
            registry.addHandler((WebSocketHandler)dispatcher, new String[]{"/socket"}).setAllowedOrigins(this.allowedOrigins);
        }
    }

    @Configuration
    @ConditionalOnBean(value={Messager.class})
    @ConditionalOnMissingBean(value={WebSocketMessager.class})
    public static class WebSocketMessagerConfiguration {
        @Autowired(required=false)
        private CounterManager counterManager;

        @Bean
        public WebSocketMessager webSocketMessager(Messager messager) {
            return new DefaultWebSocketMessager(messager, this.counterManager);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={CommandProcessorContainer.class})
    public static class WebSocketProcessorContainerConfiguration {
        @Autowired(required=false)
        private List<CommandProcessor> commandProcessors;

        @Bean(destroyMethod="destroy")
        public DefaultCommandProcessorContainer defaultWebSocketProcessorContainer() {
            DefaultCommandProcessorContainer container = new DefaultCommandProcessorContainer();
            if (this.commandProcessors != null) {
                this.commandProcessors.forEach(container::install);
            }
            return container;
        }
    }
}

