/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.socket.handler;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hswebframework.web.ThreadLocalUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenHolder;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.socket.CommandRequest;
import org.hswebframework.web.socket.WebSocketSessionListener;
import org.hswebframework.web.socket.authorize.WebSocketTokenParser;
import org.hswebframework.web.socket.handler.WebSocketCommandRequest;
import org.hswebframework.web.socket.processor.CommandProcessor;
import org.hswebframework.web.socket.processor.CommandProcessorContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class CommandWebSocketMessageDispatcher
extends TextWebSocketHandler {
    private CommandProcessorContainer processorContainer;
    private UserTokenManager userTokenManager;
    private List<WebSocketSessionListener> webSocketSessionListeners;
    private List<WebSocketTokenParser> tokenParsers;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final TextMessage requestFormatErrorMessage = new TextMessage((CharSequence)new org.hswebframework.web.socket.message.WebSocketMessage(400, "message format error!").toString());
    private static final TextMessage commandNotFoundMessage = new TextMessage((CharSequence)new org.hswebframework.web.socket.message.WebSocketMessage(404, "command not found!").toString());

    public void setWebSocketSessionListeners(List<WebSocketSessionListener> webSocketSessionListeners) {
        this.webSocketSessionListeners = webSocketSessionListeners;
    }

    public void setTokenParsers(List<WebSocketTokenParser> tokenParsers) {
        this.tokenParsers = tokenParsers;
    }

    public void setUserTokenManager(UserTokenManager userTokenManager) {
        this.userTokenManager = userTokenManager;
    }

    public void setProcessorContainer(CommandProcessorContainer processorContainer) {
        this.processorContainer = processorContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String payload = (String)message.getPayload();
        if (StringUtils.isEmpty((Object)payload)) {
            return;
        }
        String cmd = null;
        org.hswebframework.web.socket.message.WebSocketMessage errorMessage = null;
        try {
            WebSocketCommandRequest request = (WebSocketCommandRequest)JSON.parseObject((String)payload, WebSocketCommandRequest.class);
            cmd = request.getCommand();
            CommandRequest command = this.buildCommand(request, session);
            CommandProcessor processor = this.processorContainer.getProcessor(request.getCommand());
            if (processor != null) {
                processor.execute(command);
            } else {
                session.sendMessage((WebSocketMessage)commandNotFoundMessage);
            }
        }
        catch (JsonParseException e) {
            session.sendMessage((WebSocketMessage)requestFormatErrorMessage);
        }
        catch (UnAuthorizedException e) {
            errorMessage = new org.hswebframework.web.socket.message.WebSocketMessage(401, "un authorized");
        }
        catch (AccessDenyException e) {
            errorMessage = new org.hswebframework.web.socket.message.WebSocketMessage(403, "access deny");
        }
        catch (Exception e) {
            this.logger.warn("handle websocket message error ", (Throwable)e);
            errorMessage = new org.hswebframework.web.socket.message.WebSocketMessage(500, e.getMessage());
        }
        finally {
            ThreadLocalUtils.clear();
        }
        if (errorMessage != null) {
            errorMessage.setCommand(cmd);
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)errorMessage.toString()));
        }
    }

    private Authentication getAuthenticationFromSession(WebSocketSession session) {
        if (null == this.userTokenManager) {
            return null;
        }
        String token = (String)session.getAttributes().get("user_token");
        if (null == token) {
            return null;
        }
        UserToken userToken = this.userTokenManager.getByToken(token);
        if (null == userToken) {
            return null;
        }
        UserTokenHolder.setCurrent((UserToken)userToken);
        return Authentication.current().orElse(null);
    }

    private CommandRequest buildCommand(final WebSocketCommandRequest request, final WebSocketSession socketSession) {
        final Authentication authentication = this.getAuthenticationFromSession(socketSession);
        return new CommandRequest(){

            @Override
            public Authentication getAuthentication() {
                return authentication;
            }

            @Override
            public Map<String, Object> getParameters() {
                return request.getParameters();
            }

            @Override
            public WebSocketSession getSession() {
                return socketSession;
            }
        };
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        UserToken userToken;
        String token;
        this.logger.debug("new WebSocket Session Established,sessionId:{}", (Object)session.getId());
        if (this.tokenParsers != null && null != (token = (String)this.tokenParsers.stream().map(parser -> parser.parseToken(session)).filter(Objects::nonNull).findFirst().orElse(null)) && null != (userToken = this.userTokenManager.getByToken(token))) {
            UserTokenHolder.setCurrent((UserToken)userToken);
            Authentication authentication = Authentication.current().orElse(null);
            session.getAttributes().put("user_token", token);
            if (null != authentication) {
                this.logger.debug("websocket authentication init ok!");
            } else {
                this.logger.debug("websocket authentication init fail!");
            }
        }
        if (this.webSocketSessionListeners != null) {
            this.webSocketSessionListeners.forEach(webSocketSessionListener -> webSocketSessionListener.onSessionConnect(session));
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.logger.debug("WebSocket Session Closed,sessionId:{}", (Object)session.getId());
        ThreadLocalUtils.clear();
        if (this.webSocketSessionListeners != null) {
            this.webSocketSessionListeners.forEach(webSocketSessionListener -> webSocketSessionListener.onSessionClose(session));
        }
    }
}

