/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.socket.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hswebframework.web.socket.processor.CommandProcessor;
import org.hswebframework.web.socket.processor.CommandProcessorContainer;

public class DefaultCommandProcessorContainer
implements CommandProcessorContainer {
    private final ConcurrentMap<String, CommandProcessor> processorStore = new ConcurrentHashMap<String, CommandProcessor>();

    @Override
    public CommandProcessor install(CommandProcessor command) {
        command.init();
        return this.processorStore.put(command.getName(), command);
    }

    @Override
    public CommandProcessor uninstall(String name) {
        CommandProcessor processor = (CommandProcessor)this.processorStore.remove(name);
        if (null != processor) {
            processor.destroy();
        }
        return processor;
    }

    public void destroy() {
        this.getAllProcessor().forEach(CommandProcessor::destroy);
        this.processorStore.clear();
    }

    @Override
    public CommandProcessor getProcessor(String name) {
        return (CommandProcessor)this.processorStore.get(name);
    }

    @Override
    public List<CommandProcessor> getAllProcessor() {
        return new ArrayList<CommandProcessor>(this.processorStore.values());
    }
}

