/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.redis;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hswebframework.web.message.Message;
import org.hswebframework.web.message.MessageSubject;
import org.hswebframework.web.message.MessageSubscribe;
import org.hswebframework.web.message.support.QueueMessageSubject;
import org.hswebframework.web.message.support.TopicMessageSubject;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RQueue;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonMessageSubscribe<M extends Message>
implements MessageSubscribe<M> {
    private MessageSubject subject;
    private RedissonClient redisson;
    private boolean running = false;
    private int listenerId = 0;
    private List<Consumer<M>> consumers = new ArrayList<Consumer<M>>();
    private RTopic<M> topic;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Codec codec = JsonJacksonCodec.INSTANCE;

    public RedissonMessageSubscribe(MessageSubject subject, RedissonClient redisson) {
        this.subject = subject;
        this.redisson = redisson;
    }

    public RedissonMessageSubscribe(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public MessageSubscribe<M> onMessage(Consumer<M> consumer) {
        this.consumers.add(consumer);
        if (!this.running) {
            this.doRun();
        }
        return this;
    }

    public void cancel() {
        this.running = false;
        if (this.listenerId != 0 && this.topic != null) {
            this.topic.removeListener(this.listenerId);
            this.topic = null;
        }
        this.consumers.clear();
    }

    private void doRun() {
        if (this.subject instanceof QueueMessageSubject) {
            String queueName = ((QueueMessageSubject)this.subject).getQueueName();
            RQueue queue = this.redisson.getQueue(queueName, codec);
            RCountDownLatch countDownLatch = this.redisson.getCountDownLatch("cdl_" + queueName);
            Thread thread = new Thread(() -> {
                while (this.running) {
                    try {
                        if (this.redisson.isShutdown() || this.redisson.isShuttingDown()) {
                            return;
                        }
                        countDownLatch.trySetCount(1L);
                        countDownLatch.await();
                        this.consumers.forEach(cons -> {
                            Message message = (Message)queue.poll();
                            if (null != message) {
                                cons.accept(message);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        this.running = false;
                        this.logger.error("queue consumer thread interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            });
            this.running = true;
            thread.start();
            return;
        }
        if (this.subject instanceof TopicMessageSubject) {
            this.topic = this.redisson.getTopic("topic_" + ((TopicMessageSubject)this.subject).getTopic(), codec);
            this.listenerId = this.topic.addListener((channel, msg) -> this.consumers.forEach(cons -> cons.accept(msg)));
        }
        this.running = true;
    }
}

