/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.redis;

import java.util.function.Consumer;
import org.hswebframework.web.message.Message;
import org.hswebframework.web.message.MessagePublish;
import org.hswebframework.web.message.MessageSubject;
import org.hswebframework.web.message.support.MultipleQueueMessageSubject;
import org.hswebframework.web.message.support.QueueMessageSubject;
import org.hswebframework.web.message.support.TopicMessageSubject;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RQueue;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;

public class RedissonMessagePublish
implements MessagePublish {
    private MessageSubject to;
    private RedissonClient redissonClient;
    private Message message;
    private static Codec codec = JsonJacksonCodec.INSTANCE;
    private Consumer<String> queueConsumer = queueName -> {
        RQueue queue = this.redissonClient.getQueue(queueName, codec);
        RCountDownLatch downLatch = this.redissonClient.getCountDownLatch("cdl_" + queueName);
        queue.add((Object)this.message);
        downLatch.countDown();
    };

    public RedissonMessagePublish(RedissonClient redissonClient, Message message) {
        this.redissonClient = redissonClient;
        this.message = message;
    }

    public MessagePublish to(MessageSubject subject) {
        this.to = subject;
        return this;
    }

    private boolean useQueue() {
        return this.to instanceof QueueMessageSubject || this.to instanceof MultipleQueueMessageSubject;
    }

    public void send() {
        if (this.redissonClient.isShutdown() || this.redissonClient.isShuttingDown()) {
            return;
        }
        if (this.to instanceof QueueMessageSubject) {
            this.queueConsumer.accept(((QueueMessageSubject)this.to).getQueueName());
        }
        if (this.to instanceof MultipleQueueMessageSubject) {
            ((MultipleQueueMessageSubject)this.to).getQueueName().forEach(this.queueConsumer);
        }
        if (this.to instanceof TopicMessageSubject) {
            RTopic topic = this.redissonClient.getTopic("topic_" + ((TopicMessageSubject)this.to).getTopic(), codec);
            topic.publish((Object)this.message);
        }
    }
}

