/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.memory;

import java.util.UUID;
import java.util.function.Consumer;
import org.hswebframework.web.message.Message;
import org.hswebframework.web.message.MessageSubscribe;
import org.hswebframework.web.message.memory.MemoryTopic;

public class MemoryTopicSubscribe<M extends Message>
implements MessageSubscribe<M> {
    private MemoryTopic topic;
    private String id;

    public MemoryTopicSubscribe(MemoryTopic topic) {
        this.topic = topic;
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public MessageSubscribe<M> onMessage(Consumer<M> consumer) {
        this.topic.subscribe(this.id, consumer);
        return this;
    }

    @Override
    public void cancel() {
        this.topic.remove(this.id);
    }
}

