/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hswebframework.web.message.Message;

class MemoryTopic<M extends Message> {
    private Map<String, List<Consumer<M>>> consumers = new ConcurrentHashMap<String, List<Consumer<M>>>();

    MemoryTopic() {
    }

    public void remove(String id) {
        this.consumers.remove(id);
    }

    public void subscribe(String id, Consumer<M> consumer) {
        this.consumers.computeIfAbsent(id, i -> new ArrayList()).add(consumer);
    }

    public void publish(M message) {
        this.consumers.values().stream().flatMap(Collection::stream).forEach(consumer -> consumer.accept(message));
    }
}

