/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.memory;

import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import org.hswebframework.web.message.Message;
import org.hswebframework.web.message.MessagePublish;
import org.hswebframework.web.message.MessageSubject;
import org.hswebframework.web.message.memory.MemoryMessager;
import org.hswebframework.web.message.memory.MemoryTopic;
import org.hswebframework.web.message.support.MultipleQueueMessageSubject;
import org.hswebframework.web.message.support.QueueMessageSubject;
import org.hswebframework.web.message.support.TopicMessageSubject;

public class MemoryPublish
implements MessagePublish {
    private MessageSubject subject;
    private Function<String, MemoryMessager.QueueConsumer<Message>> queueGetter;
    private Function<String, MemoryTopic<Message>> topicGetter;
    private Message message;
    private static Random random = new Random();

    public MemoryPublish(Function<String, MemoryMessager.QueueConsumer<Message>> queueGetter, Function<String, MemoryTopic<Message>> topicGetter, Message message) {
        this.queueGetter = queueGetter;
        this.topicGetter = topicGetter;
        this.message = message;
    }

    @Override
    public MessagePublish to(MessageSubject subject) {
        this.subject = subject;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pubQueue(String name) {
        MemoryMessager.QueueConsumer<Message> queueConsumer = this.queueGetter.apply(name);
        queueConsumer.lock.readLock().lock();
        try {
            int size = queueConsumer.consumers.size();
            if (size > 0) {
                queueConsumer.consumers.get(random.nextInt(size)).accept(this.message);
            }
        }
        finally {
            queueConsumer.lock.readLock().unlock();
        }
    }

    @Override
    public void send() {
        Objects.requireNonNull(this.subject);
        if (this.subject instanceof QueueMessageSubject) {
            this.pubQueue(((QueueMessageSubject)this.subject).getQueueName());
        }
        if (this.subject instanceof MultipleQueueMessageSubject) {
            ((MultipleQueueMessageSubject)this.subject).getQueueName().forEach(this::pubQueue);
        }
        if (this.subject instanceof TopicMessageSubject) {
            this.topicGetter.apply(((TopicMessageSubject)this.subject).getTopic()).publish(this.message);
        }
    }
}

