/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.message.builder;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hswebframework.web.message.MessageSubject;
import org.hswebframework.web.message.builder.MessageSubjectBuilder;
import org.hswebframework.web.message.support.MultipleQueueMessageSubject;
import org.hswebframework.web.message.support.MultipleUserMessageSubject;
import org.hswebframework.web.message.support.QueueMessageSubject;
import org.hswebframework.web.message.support.TopicMessageSubject;
import org.hswebframework.web.message.support.UserMessageSubject;

public class SimpleMessageSubjectBuilder
implements MessageSubjectBuilder,
Serializable {
    @Override
    public UserMessageSubject user(String userId) {
        return () -> userId;
    }

    @Override
    public MultipleUserMessageSubject users(String ... userIds) {
        return () -> new HashSet<String>(Arrays.asList(userIds));
    }

    @Override
    public MultipleUserMessageSubject users(Set<String> userIds) {
        return () -> userIds;
    }

    @Override
    public MessageSubject system() {
        return null;
    }

    @Override
    public TopicMessageSubject topic(String topic) {
        return () -> topic;
    }

    @Override
    public QueueMessageSubject queue(String queueName) {
        return () -> queueName;
    }

    @Override
    public MultipleQueueMessageSubject queues(String ... userIds) {
        Set<String> ids = Arrays.stream(userIds).collect(Collectors.toSet());
        return this.queues(ids);
    }

    @Override
    public MultipleQueueMessageSubject queues(Set<String> userIds) {
        return () -> userIds;
    }
}

