/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.jta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.hswebframework.web.datasource.jta.AtomikosDataSourceConfig;
import org.hswebframework.web.datasource.jta.JtaDataSourceRepository;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="hsweb.datasource")
public class InMemoryAtomikosDataSourceRepository
implements JtaDataSourceRepository {
    private Map<String, AtomikosDataSourceConfig> jta = new HashMap<String, AtomikosDataSourceConfig>();

    @PostConstruct
    public void init() {
        this.jta.forEach((id, config) -> {
            if (config.getId() == null) {
                config.setId(id);
            } else if (!config.getId().equals(id)) {
                this.jta.put(config.getId(), (AtomikosDataSourceConfig)((Object)config));
            }
        });
    }

    public List<AtomikosDataSourceConfig> findAll() {
        return new ArrayList<AtomikosDataSourceConfig>(this.jta.values());
    }

    public AtomikosDataSourceConfig findById(String dataSourceId) {
        return this.jta.get(dataSourceId);
    }

    public AtomikosDataSourceConfig add(AtomikosDataSourceConfig config) {
        return this.jta.put(config.getId(), config);
    }

    public AtomikosDataSourceConfig remove(String dataSourceId) {
        return this.jta.remove(dataSourceId);
    }

    public Map<String, AtomikosDataSourceConfig> getJta() {
        return this.jta;
    }

    public void setJta(Map<String, AtomikosDataSourceConfig> jta) {
        this.jta = jta;
    }
}

