/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.jta;

import com.atomikos.jdbc.AtomikosDataSourceBean;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XADataSource;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomikosDataSourceConfig
extends DynamicDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(AtomikosDataSourceConfig.class);
    private static final long serialVersionUID = 5588085000663972571L;
    private int minPoolSize = 5;
    private int maxPoolSize = 200;
    private int borrowConnectionTimeout = 60;
    private int reapTimeout = 0;
    private int maxIdleTime = 60;
    private int maintenanceInterval = 60;
    private int defaultIsolationLevel = -1;
    private String xaDataSourceClassName = null;
    private int loginTimeout = 0;
    private String testQuery = null;
    private int maxLifetime = 0;
    private Properties xaProperties = null;
    private int initTimeout = 10;

    public void putProperties(AtomikosDataSourceBean atomikosDataSourceBean) {
        if (null != this.xaProperties) {
            this.xaProperties.entrySet().forEach(entry -> entry.setValue(String.valueOf(entry.getValue())));
        }
        XADataSource dataSource = (XADataSource)Class.forName(this.getXaDataSourceClassName()).newInstance();
        FastBeanCopier.copy((Object)this.xaProperties, (Object)dataSource, (String[])new String[0]);
        atomikosDataSourceBean.setXaDataSource(dataSource);
        atomikosDataSourceBean.setXaDataSourceClassName(this.getXaDataSourceClassName());
        atomikosDataSourceBean.setBorrowConnectionTimeout(this.getBorrowConnectionTimeout());
        if (this.loginTimeout != 0) {
            try {
                atomikosDataSourceBean.setLoginTimeout(this.getLoginTimeout());
            }
            catch (SQLException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        atomikosDataSourceBean.setMaxIdleTime(this.getMaxIdleTime());
        atomikosDataSourceBean.setMaxPoolSize(this.getMaxPoolSize());
        atomikosDataSourceBean.setMinPoolSize(this.getMinPoolSize());
        atomikosDataSourceBean.setDefaultIsolationLevel(this.getDefaultIsolationLevel());
        atomikosDataSourceBean.setMaintenanceInterval(this.getMaintenanceInterval());
        atomikosDataSourceBean.setReapTimeout(this.getReapTimeout());
        atomikosDataSourceBean.setTestQuery(this.getTestQuery());
        atomikosDataSourceBean.setXaProperties(this.getXaProperties());
        atomikosDataSourceBean.setMaxLifetime(this.getMaxLifetime());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomikosDataSourceConfig)) {
            return false;
        }
        AtomikosDataSourceConfig other = (AtomikosDataSourceConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMinPoolSize() != other.getMinPoolSize()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getBorrowConnectionTimeout() != other.getBorrowConnectionTimeout()) {
            return false;
        }
        if (this.getReapTimeout() != other.getReapTimeout()) {
            return false;
        }
        if (this.getMaxIdleTime() != other.getMaxIdleTime()) {
            return false;
        }
        if (this.getMaintenanceInterval() != other.getMaintenanceInterval()) {
            return false;
        }
        if (this.getDefaultIsolationLevel() != other.getDefaultIsolationLevel()) {
            return false;
        }
        String this$xaDataSourceClassName = this.getXaDataSourceClassName();
        String other$xaDataSourceClassName = other.getXaDataSourceClassName();
        if (this$xaDataSourceClassName == null ? other$xaDataSourceClassName != null : !this$xaDataSourceClassName.equals(other$xaDataSourceClassName)) {
            return false;
        }
        if (this.getLoginTimeout() != other.getLoginTimeout()) {
            return false;
        }
        String this$testQuery = this.getTestQuery();
        String other$testQuery = other.getTestQuery();
        if (this$testQuery == null ? other$testQuery != null : !this$testQuery.equals(other$testQuery)) {
            return false;
        }
        if (this.getMaxLifetime() != other.getMaxLifetime()) {
            return false;
        }
        Properties this$xaProperties = this.getXaProperties();
        Properties other$xaProperties = other.getXaProperties();
        if (this$xaProperties == null ? other$xaProperties != null : !((Object)this$xaProperties).equals(other$xaProperties)) {
            return false;
        }
        return this.getInitTimeout() == other.getInitTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AtomikosDataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getMinPoolSize();
        result = result * 59 + this.getMaxPoolSize();
        result = result * 59 + this.getBorrowConnectionTimeout();
        result = result * 59 + this.getReapTimeout();
        result = result * 59 + this.getMaxIdleTime();
        result = result * 59 + this.getMaintenanceInterval();
        result = result * 59 + this.getDefaultIsolationLevel();
        String $xaDataSourceClassName = this.getXaDataSourceClassName();
        result = result * 59 + ($xaDataSourceClassName == null ? 43 : $xaDataSourceClassName.hashCode());
        result = result * 59 + this.getLoginTimeout();
        String $testQuery = this.getTestQuery();
        result = result * 59 + ($testQuery == null ? 43 : $testQuery.hashCode());
        result = result * 59 + this.getMaxLifetime();
        Properties $xaProperties = this.getXaProperties();
        result = result * 59 + ($xaProperties == null ? 43 : ((Object)$xaProperties).hashCode());
        result = result * 59 + this.getInitTimeout();
        return result;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    public int getReapTimeout() {
        return this.reapTimeout;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getTestQuery() {
        return this.testQuery;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public int getInitTimeout() {
        return this.initTimeout;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setBorrowConnectionTimeout(int borrowConnectionTimeout) {
        this.borrowConnectionTimeout = borrowConnectionTimeout;
    }

    public void setReapTimeout(int reapTimeout) {
        this.reapTimeout = reapTimeout;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaintenanceInterval(int maintenanceInterval) {
        this.maintenanceInterval = maintenanceInterval;
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public void setXaDataSourceClassName(String xaDataSourceClassName) {
        this.xaDataSourceClassName = xaDataSourceClassName;
    }

    public void setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public void setInitTimeout(int initTimeout) {
        this.initTimeout = initTimeout;
    }

    public String toString() {
        return "AtomikosDataSourceConfig(minPoolSize=" + this.getMinPoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", reapTimeout=" + this.getReapTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", defaultIsolationLevel=" + this.getDefaultIsolationLevel() + ", xaDataSourceClassName=" + this.getXaDataSourceClassName() + ", loginTimeout=" + this.getLoginTimeout() + ", testQuery=" + this.getTestQuery() + ", maxLifetime=" + this.getMaxLifetime() + ", xaProperties=" + this.getXaProperties() + ", initTimeout=" + this.getInitTimeout() + ")";
    }
}

