/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.jta;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.hswebframework.web.datasource.DynamicDataSourceAutoConfiguration;
import org.hswebframework.web.datasource.DynamicDataSourceService;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.jta.AtomikosDataSourceConfig;
import org.hswebframework.web.datasource.jta.InMemoryAtomikosDataSourceRepository;
import org.hswebframework.web.datasource.jta.JtaDynamicDataSourceService;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class})
public class AtomikosDataSourceAutoConfiguration {
    @Bean(initMethod="init", destroyMethod="destroy", value={"datasource"})
    @Primary
    public AtomikosDataSourceBean datasource() {
        return new AtomikosDataSourceBean();
    }

    @ConditionalOnMissingBean(value={DynamicDataSourceConfigRepository.class})
    @Bean
    public DynamicDataSourceConfigRepository inMemoryAtomikosDataSourceRepository() {
        return new InMemoryAtomikosDataSourceRepository();
    }

    @Bean
    @Primary
    public DynamicDataSourceService jtaDynamicDataSourceService(DynamicDataSourceConfigRepository<AtomikosDataSourceConfig> repository, DataSource dataSource) throws SQLException {
        return new JtaDynamicDataSourceService(repository, dataSource);
    }
}

