/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.jta;

import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hswebframework.web.datasource.DynamicDataSource;
import org.hswebframework.web.datasource.DynamicDataSourceProxy;
import org.hswebframework.web.datasource.config.DynamicDataSourceConfigRepository;
import org.hswebframework.web.datasource.jta.AtomikosDataSourceConfig;
import org.hswebframework.web.datasource.service.AbstractDynamicDataSourceService;
import org.hswebframework.web.datasource.service.DataSourceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;

public class JtaDynamicDataSourceService
extends AbstractDynamicDataSourceService<AtomikosDataSourceConfig> {
    private Executor executor = Executors.newFixedThreadPool(4);
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public JtaDynamicDataSourceService(DynamicDataSourceConfigRepository<AtomikosDataSourceConfig> repository, DynamicDataSource defaultDataSource) {
        super(repository, defaultDataSource);
    }

    public JtaDynamicDataSourceService(DynamicDataSourceConfigRepository<AtomikosDataSourceConfig> repository, DataSource dataSource) throws SQLException {
        super(repository, dataSource);
    }

    @Autowired(required=false)
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected DataSourceCache createCache(AtomikosDataSourceConfig config) {
        final AtomikosDataSourceBean atomikosDataSourceBean = new AtomikosDataSourceBean();
        config.putProperties((com.atomikos.jdbc.AtomikosDataSourceBean)atomikosDataSourceBean);
        atomikosDataSourceBean.setBeanName("dynamic_ds_" + config.getId());
        atomikosDataSourceBean.setUniqueResourceName("dynamic_ds_" + config.getId());
        AtomicInteger successCounter = new AtomicInteger();
        CountDownLatch downLatch = new CountDownLatch(1);
        DataSourceCache cache = new DataSourceCache(config.hashCode(), (DynamicDataSource)new DynamicDataSourceProxy(config.getId(), (DataSource)atomikosDataSourceBean), downLatch, config){

            public void closeDataSource() {
                super.closeDataSource();
                atomikosDataSourceBean.close();
                XADataSource dataSource = atomikosDataSourceBean.getXaDataSource();
                if (dataSource instanceof Closeable) {
                    try {
                        ((Closeable)((Object)dataSource)).close();
                    }
                    catch (IOException e) {
                        JtaDynamicDataSourceService.this.logger.error("close xa datasource error", (Throwable)e);
                    }
                } else {
                    JtaDynamicDataSourceService.this.logger.warn("XADataSource is not instanceof Closeable!", (Object)Thread.currentThread().getStackTrace());
                }
            }
        };
        this.executor.execute(() -> {
            try {
                atomikosDataSourceBean.init();
                successCounter.incrementAndGet();
                downLatch.countDown();
            }
            catch (Exception e) {
                this.logger.error("init datasource {} error", (Object)config.getId(), (Object)e);
            }
        });
        this.executor.execute(() -> {
            try {
                Thread.sleep((long)config.getInitTimeout() * 1000L);
            }
            catch (InterruptedException ignored) {
                this.logger.warn(ignored.getMessage(), (Throwable)ignored);
                Thread.currentThread().interrupt();
            }
            finally {
                if (successCounter.get() == 0) {
                    this.logger.error("init timeout ({}ms)", (Object)config.getInitTimeout());
                    cache.closeDataSource();
                    if (downLatch.getCount() > 0L) {
                        downLatch.countDown();
                    }
                }
            }
        });
        return cache;
    }
}

