/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.concurent;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.aopalliance.aop.Advice;
import org.hswebframework.web.ExpressionUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.concurrent.RateLimiterManager;
import org.hswebframework.web.concurrent.annotation.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public class RateLimiterAopAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterAopAdvisor.class);
    private static final long serialVersionUID = -1076122956392948260L;
    private static final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public RateLimiterAopAdvisor(RateLimiterManager rateLimiterManager) {
        this.setAdvice((Advice)((MethodBeforeAdvice)(method, args, target) -> {
            String[] names = nameDiscoverer.getParameterNames(method);
            RateLimiter limiter = Optional.ofNullable(AnnotationUtils.findAnnotation((Method)method, RateLimiter.class)).orElseGet(() -> (RateLimiter)AnnotationUtils.findAnnotation((Class)ClassUtils.getUserClass((Object)target), RateLimiter.class));
            if (limiter != null) {
                ArrayList<String> keyExpressionList = new ArrayList<String>(Arrays.asList(limiter.key()));
                if (keyExpressionList.isEmpty()) {
                    keyExpressionList.add(method.toString());
                }
                for (String keyExpress : keyExpressionList) {
                    if (keyExpress.contains("${")) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("user", Authentication.current().map(Authentication::getUser).orElse(null));
                        for (int i = 0; i < args.length; ++i) {
                            params.put(names.length > i ? names[i] : "arg" + i, args[i]);
                            params.put("arg" + i, args[i]);
                        }
                        keyExpress = ExpressionUtils.analytical((String)keyExpress, params, (String)"spel");
                    }
                    log.debug("do rate limiter:[{}]. ", (Object)keyExpress);
                    boolean success = rateLimiterManager.getRateLimiter(keyExpress, limiter.permits(), limiter.timeUnit()).tryAcquire(limiter.acquire(), limiter.acquireTimeUnit());
                    if (success) continue;
                    throw new TimeoutException("\u8bf7\u6c42\u8d85\u65f6");
                }
            }
        }));
    }

    public boolean matches(Method method, Class<?> targetClass) {
        return AnnotationUtils.findAnnotation((Method)method, RateLimiter.class) != null || AnnotationUtils.findAnnotation(targetClass, RateLimiter.class) != null;
    }
}

