/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.concurrent.lock.starter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.AopUtils;
import org.hswebframework.web.boost.aop.context.MethodInterceptorHolder;
import org.hswebframework.web.concurrent.lock.LockManager;
import org.hswebframework.web.concurrent.lock.annotation.ReadLock;
import org.hswebframework.web.concurrent.lock.annotation.WriteLock;
import org.hswebframework.web.concurrent.lock.starter.LockProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;

public class AopLockAdvisor
extends StaticMethodMatcherPointcutAdvisor {
    private static final Logger log = LoggerFactory.getLogger(AopLockAdvisor.class);

    public AopLockAdvisor(LockManager lockManager) {
        Objects.requireNonNull(lockManager);
        this.setAdvice((Advice)((MethodInterceptor)methodInvocation -> {
            MethodInterceptorHolder holder = MethodInterceptorHolder.create((MethodInvocation)methodInvocation);
            org.hswebframework.web.concurrent.lock.annotation.Lock lockAnn = (org.hswebframework.web.concurrent.lock.annotation.Lock)holder.findMethodAnnotation(org.hswebframework.web.concurrent.lock.annotation.Lock.class);
            ReadLock readLockAnn = (ReadLock)holder.findMethodAnnotation(ReadLock.class);
            WriteLock writeLock = (WriteLock)holder.findMethodAnnotation(WriteLock.class);
            ArrayList<LockProcessor<Object, Lock>> lockProcessors = new ArrayList<LockProcessor<Object, Lock>>();
            if (null != lockAnn) {
                lockProcessors.add(this.initLockInfo(lockAnn.timeout(), lockAnn.timeUnit(), LockProcessor.build(lockAnn, holder).lockNameIs(org.hswebframework.web.concurrent.lock.annotation.Lock::value).lockIs(arg_0 -> ((LockManager)lockManager).getLock(arg_0))));
            }
            if (null != readLockAnn) {
                lockProcessors.add(this.initLockInfo(readLockAnn.timeout(), readLockAnn.timeUnit(), LockProcessor.build(readLockAnn, holder).lockNameIs(ReadLock::value).lockIs(name -> lockManager.getReadWriteLock(name).readLock())));
            }
            if (null != writeLock) {
                lockProcessors.add(this.initLockInfo(writeLock.timeout(), writeLock.timeUnit(), LockProcessor.build(writeLock, holder).lockNameIs(WriteLock::value).lockIs(name -> lockManager.getReadWriteLock(name).writeLock())));
            }
            boolean lockError = false;
            try {
                for (LockProcessor lockProcessor : lockProcessors) {
                    Throwable throwable = lockProcessor.doLock();
                    if (throwable == null) continue;
                    lockError = true;
                    throw throwable;
                }
                Object object = methodInvocation.proceed();
                return object;
            }
            finally {
                for (LockProcessor lockProcessor : lockProcessors) {
                    try {
                        lockProcessor.doUnlock();
                    }
                    catch (Exception e) {
                        if (lockError) continue;
                        log.error("unlock {} error", (Object)methodInvocation.getMethod(), (Object)e);
                    }
                }
            }
        }));
    }

    protected <A extends Annotation> LockProcessor<A, Lock> initLockInfo(long timeout, TimeUnit timeUnit, LockProcessor<A, Lock> lockProcessor) {
        return lockProcessor.lock(lock -> lock.tryLock(timeout, timeUnit)).unlock(lock -> {
            lock.unlock();
            return true;
        }).init();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public boolean matches(Method method, Class<?> aClass) {
        org.hswebframework.web.concurrent.lock.annotation.Lock lock = (org.hswebframework.web.concurrent.lock.annotation.Lock)AopUtils.findMethodAnnotation(aClass, (Method)method, org.hswebframework.web.concurrent.lock.annotation.Lock.class);
        if (null != lock) {
            return true;
        }
        ReadLock readLock = (ReadLock)AopUtils.findMethodAnnotation(aClass, (Method)method, ReadLock.class);
        if (null != readLock) {
            return true;
        }
        WriteLock writeLock = (WriteLock)AopUtils.findMethodAnnotation(aClass, (Method)method, WriteLock.class);
        return null != writeLock;
    }
}

