/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.counter.redis;

import org.hswebframework.web.concurrent.counter.BloomFilterManager;
import org.hswebframework.web.concurrent.counter.CounterAutoConfiguration;
import org.hswebframework.web.concurrent.counter.CounterManager;
import org.hswebframework.web.counter.redis.RedisBloomFilterManager;
import org.hswebframework.web.counter.redis.RedissonCounterManager;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={CounterAutoConfiguration.class})
public class RedisCounterAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={RedissonClient.class})
    public CounterManager counterManager(RedissonClient client) {
        return new RedissonCounterManager(client);
    }

    @Bean
    @ConditionalOnBean(value={BloomFilterManager.class})
    public BloomFilterManager bloomFilterManager(RedissonClient client) {
        return new RedisBloomFilterManager(client);
    }
}

