/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.counter.redis;

import java.beans.ConstructorProperties;
import org.hswebframework.web.concurrent.counter.AbstractBoomFilterManager;
import org.hswebframework.web.concurrent.counter.BloomFilter;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;

public class RedisBloomFilterManager
extends AbstractBoomFilterManager {
    private RedissonClient redissonClient;

    protected BloomFilter createBloomFilter(String name) {
        final RBloomFilter filter = this.redissonClient.getBloomFilter("hsweb:bloom-filter:" + name, (Codec)StringCodec.INSTANCE);
        filter.tryInit(55000000L, 0.01);
        return new BloomFilter(){

            public boolean put(String unique) {
                return filter.add((Object)unique);
            }

            public boolean contains(String unique) {
                return filter.contains((Object)unique);
            }
        };
    }

    @ConstructorProperties(value={"redissonClient"})
    public RedisBloomFilterManager(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

