/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.supports;

import com.github.benmanes.caffeine.cache.Cache;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.hswebframework.web.cache.ReactiveCache;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CaffeineReactiveCache<E>
implements ReactiveCache<E> {
    private Cache<Object, Object> cache;

    @Override
    public Flux<E> getFlux(Object key) {
        return Flux.defer(() -> {
            Object v = this.cache.getIfPresent(key);
            if (v == null) {
                return Flux.empty();
            }
            if (v instanceof Iterable) {
                return Flux.fromIterable((Iterable)((Iterable)v));
            }
            return Flux.just((Object)v);
        });
    }

    @Override
    public Mono<E> getMono(Object key) {
        return Mono.defer(() -> {
            Object v = this.cache.getIfPresent(key);
            if (v == null) {
                return Mono.empty();
            }
            return Mono.just((Object)v);
        });
    }

    @Override
    public Mono<Void> put(Object key, Publisher<E> data) {
        return Mono.defer(() -> {
            if (data instanceof Flux) {
                return ((Flux)data).collectList().doOnNext(v -> this.cache.put(key, v)).then();
            }
            if (data instanceof Mono) {
                return ((Mono)data).doOnNext(v -> this.cache.put(key, v)).then();
            }
            return Mono.error((Throwable)new UnsupportedOperationException("unsupport publisher:" + data));
        });
    }

    @Override
    public Mono<Void> evictAll(Iterable<?> key) {
        return Mono.fromRunnable(() -> this.cache.invalidateAll(key));
    }

    @Override
    public Flux<E> getAll(Object ... keys) {
        return Flux.defer(() -> Flux.fromIterable(this.cache.getAllPresent(Arrays.asList(keys)).values()).map(e -> e));
    }

    @Override
    public Mono<Void> evict(Object key) {
        return Mono.fromRunnable(() -> this.cache.invalidate(key));
    }

    @Override
    public Mono<Void> clear() {
        return Mono.fromRunnable(() -> this.cache.invalidateAll());
    }

    @ConstructorProperties(value={"cache"})
    public CaffeineReactiveCache(Cache<Object, Object> cache) {
        this.cache = cache;
    }
}

