/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import org.hswebframework.web.cache.ReactiveCache;
import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.cache.supports.CaffeineReactiveCacheManager;
import org.hswebframework.web.cache.supports.GuavaReactiveCacheManager;
import org.hswebframework.web.cache.supports.RedisLocalReactiveCacheManager;
import org.hswebframework.web.cache.supports.UnSupportedReactiveCache;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="hsweb.cache")
public class ReactiveCacheProperties {
    private Type type = Type.none;
    private GuavaProperties guava = new GuavaProperties();
    private CaffeineProperties caffeine = new CaffeineProperties();
    private RedisProperties redis = new RedisProperties();

    public boolean anyProviderPresent() {
        return ClassUtils.isPresent((String)"com.google.common.cache.Cache", (ClassLoader)this.getClass().getClassLoader()) || ClassUtils.isPresent((String)"com.github.benmanes.caffeine.cache.Cache", (ClassLoader)this.getClass().getClassLoader()) || ClassUtils.isPresent((String)"org.springframework.data.redis.core.ReactiveRedisOperations", (ClassLoader)this.getClass().getClassLoader());
    }

    private ReactiveCacheManager createUnsupported() {
        return new ReactiveCacheManager(){

            @Override
            public <E> ReactiveCache<E> getCache(String name) {
                return UnSupportedReactiveCache.getInstance();
            }
        };
    }

    public ReactiveCacheManager createCacheManager(ApplicationContext context) {
        if (!this.anyProviderPresent()) {
            return new ReactiveCacheManager(){

                @Override
                public <E> ReactiveCache<E> getCache(String name) {
                    return UnSupportedReactiveCache.getInstance();
                }
            };
        }
        if (this.type == Type.redis) {
            ReactiveRedisOperations operations = StringUtils.hasText((String)this.redis.getBeanName()) ? (ReactiveRedisOperations)context.getBean(this.redis.getBeanName(), ReactiveRedisOperations.class) : (ReactiveRedisOperations)context.getBeanProvider(ResolvableType.forClassWithGenerics(ReactiveRedisOperations.class, (Class[])new Class[]{Object.class, Object.class})).getIfAvailable();
            return new RedisLocalReactiveCacheManager((ReactiveRedisOperations<Object, Object>)operations, this.createCacheManager(this.redis.localCacheType));
        }
        return this.createCacheManager(this.type);
    }

    private ReactiveCacheManager createCacheManager(Type type) {
        switch (type) {
            case guava: {
                return this.getGuava().createCacheManager();
            }
            case caffeine: {
                return this.getCaffeine().createCacheManager();
            }
        }
        return this.createUnsupported();
    }

    public Type getType() {
        return this.type;
    }

    public GuavaProperties getGuava() {
        return this.guava;
    }

    public CaffeineProperties getCaffeine() {
        return this.caffeine;
    }

    public RedisProperties getRedis() {
        return this.redis;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setGuava(GuavaProperties guava) {
        this.guava = guava;
    }

    public void setCaffeine(CaffeineProperties caffeine) {
        this.caffeine = caffeine;
    }

    public void setRedis(RedisProperties redis) {
        this.redis = redis;
    }

    public static enum Type {
        redis,
        caffeine,
        guava,
        none;

    }

    static enum Strength {
        WEAK,
        SOFT;

    }

    public static class CaffeineProperties {
        long maximumSize = 1024L;
        int initialCapacity = 64;
        Duration expireAfterWrite = Duration.ofHours(6L);
        Duration expireAfterAccess = Duration.ofHours(1L);
        Strength keyStrength = Strength.SOFT;
        Strength valueStrength = Strength.SOFT;

        ReactiveCacheManager createCacheManager() {
            return new CaffeineReactiveCacheManager(this.createBuilder());
        }

        Caffeine<Object, Object> createBuilder() {
            Caffeine builder = Caffeine.newBuilder().expireAfterAccess(this.expireAfterAccess).expireAfterWrite(this.expireAfterWrite).maximumSize(this.maximumSize);
            if (this.valueStrength == Strength.SOFT) {
                builder.softValues();
            } else {
                builder.weakValues();
            }
            if (this.keyStrength == Strength.WEAK) {
                builder.weakKeys();
            }
            return builder;
        }

        public long getMaximumSize() {
            return this.maximumSize;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public Duration getExpireAfterWrite() {
            return this.expireAfterWrite;
        }

        public Duration getExpireAfterAccess() {
            return this.expireAfterAccess;
        }

        public Strength getKeyStrength() {
            return this.keyStrength;
        }

        public Strength getValueStrength() {
            return this.valueStrength;
        }

        public void setMaximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
        }

        public void setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public void setExpireAfterWrite(Duration expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
        }

        public void setExpireAfterAccess(Duration expireAfterAccess) {
            this.expireAfterAccess = expireAfterAccess;
        }

        public void setKeyStrength(Strength keyStrength) {
            this.keyStrength = keyStrength;
        }

        public void setValueStrength(Strength valueStrength) {
            this.valueStrength = valueStrength;
        }
    }

    public static class GuavaProperties {
        long maximumSize = 1024L;
        int initialCapacity = 64;
        Duration expireAfterWrite = Duration.ofHours(6L);
        Duration expireAfterAccess = Duration.ofHours(1L);
        Strength keyStrength = Strength.SOFT;
        Strength valueStrength = Strength.SOFT;

        ReactiveCacheManager createCacheManager() {
            return new GuavaReactiveCacheManager(this.createBuilder());
        }

        CacheBuilder<Object, Object> createBuilder() {
            CacheBuilder builder = CacheBuilder.newBuilder().expireAfterAccess(this.expireAfterAccess).expireAfterWrite(this.expireAfterWrite).maximumSize(this.maximumSize);
            if (this.valueStrength == Strength.SOFT) {
                builder.softValues();
            } else {
                builder.weakValues();
            }
            if (this.keyStrength == Strength.WEAK) {
                builder.weakKeys();
            }
            return builder;
        }

        public long getMaximumSize() {
            return this.maximumSize;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public Duration getExpireAfterWrite() {
            return this.expireAfterWrite;
        }

        public Duration getExpireAfterAccess() {
            return this.expireAfterAccess;
        }

        public Strength getKeyStrength() {
            return this.keyStrength;
        }

        public Strength getValueStrength() {
            return this.valueStrength;
        }

        public void setMaximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
        }

        public void setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public void setExpireAfterWrite(Duration expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
        }

        public void setExpireAfterAccess(Duration expireAfterAccess) {
            this.expireAfterAccess = expireAfterAccess;
        }

        public void setKeyStrength(Strength keyStrength) {
            this.keyStrength = keyStrength;
        }

        public void setValueStrength(Strength valueStrength) {
            this.valueStrength = valueStrength;
        }
    }

    public static class RedisProperties {
        private String beanName;
        private Type localCacheType = Type.caffeine;

        public String getBeanName() {
            return this.beanName;
        }

        public Type getLocalCacheType() {
            return this.localCacheType;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public void setLocalCacheType(Type localCacheType) {
            this.localCacheType = localCacheType;
        }
    }
}

