/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.spring.fix;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hswebframework.web.cache.spring.fix.FixUseSupperClassAnnotationParser;
import org.hswebframework.web.cache.spring.fix.FixUseSupperClassCacheAnnotationParser;
import org.hswebframework.web.cache.spring.fix.FixUseSupperClassFallbackCacheOperationSource;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.util.Assert;

public class FixUseSupperClassCacheOperationSource
extends FixUseSupperClassFallbackCacheOperationSource
implements Serializable {
    private boolean publicMethodsOnly;
    private final Set<FixUseSupperClassCacheAnnotationParser> annotationParsers;

    public FixUseSupperClassCacheOperationSource() {
        this(true);
    }

    public FixUseSupperClassCacheOperationSource(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
        this.annotationParsers = new LinkedHashSet<FixUseSupperClassCacheAnnotationParser>(1);
        this.annotationParsers.add(new FixUseSupperClassAnnotationParser());
    }

    public FixUseSupperClassCacheOperationSource(FixUseSupperClassCacheAnnotationParser annotationParser) {
        this.publicMethodsOnly = true;
        Assert.notNull((Object)annotationParser, (String)"CacheAnnotationParser must not be null");
        this.annotationParsers = Collections.singleton(annotationParser);
    }

    public FixUseSupperClassCacheOperationSource(FixUseSupperClassCacheAnnotationParser ... annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one CacheAnnotationParser needs to be specified");
        LinkedHashSet<FixUseSupperClassCacheAnnotationParser> parsers = new LinkedHashSet<FixUseSupperClassCacheAnnotationParser>(annotationParsers.length);
        Collections.addAll(parsers, annotationParsers);
        this.annotationParsers = parsers;
    }

    public FixUseSupperClassCacheOperationSource(Set<FixUseSupperClassCacheAnnotationParser> annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty(annotationParsers, (String)"At least one CacheAnnotationParser needs to be specified");
        this.annotationParsers = annotationParsers;
    }

    @Override
    protected Collection<CacheOperation> findCacheOperations(Class<?> targetClass, Method method) {
        return this.determineCacheOperations(parser -> parser.parseCacheAnnotations(targetClass, method));
    }

    @Override
    protected Collection<CacheOperation> findCacheOperations(Class<?> clazz) {
        return this.determineCacheOperations(parser -> parser.parseCacheAnnotations(clazz));
    }

    protected Collection<CacheOperation> determineCacheOperations(CacheOperationProvider provider) {
        ArrayList<CacheOperation> ops = null;
        for (FixUseSupperClassCacheAnnotationParser annotationParser : this.annotationParsers) {
            Collection<CacheOperation> annOps = provider.getCacheOperations(annotationParser);
            if (annOps == null) continue;
            if (ops == null) {
                ops = new ArrayList<CacheOperation>();
            }
            ops.addAll(annOps);
        }
        return ops;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FixUseSupperClassCacheOperationSource)) {
            return false;
        }
        FixUseSupperClassCacheOperationSource otherCos = (FixUseSupperClassCacheOperationSource)other;
        return this.annotationParsers.equals(otherCos.annotationParsers) && this.publicMethodsOnly == otherCos.publicMethodsOnly;
    }

    public int hashCode() {
        return this.annotationParsers.hashCode();
    }

    public void setPublicMethodsOnly(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
    }

    protected static interface CacheOperationProvider {
        public Collection<CacheOperation> getCacheOperations(FixUseSupperClassCacheAnnotationParser var1);
    }
}

