/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.cache.spring.fix;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.hswebframework.web.cache.spring.fix.FixUseSupperClassCacheAnnotationParser;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class FixUseSupperClassAnnotationParser
implements FixUseSupperClassCacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(Class targetClass, Method method) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(targetClass);
        return this.parseCacheAnnotations(defaultConfig, (AnnotatedElement)method);
    }

    public Collection<CacheOperation> parseCacheAnnotations(Class<?> type) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(type);
        return this.parseCacheAnnotations(defaultConfig, type);
    }

    public Collection<CacheOperation> parseCacheAnnotations(Method method) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(method.getDeclaringClass());
        return this.parseCacheAnnotations(defaultConfig, (AnnotatedElement)method);
    }

    protected Collection<CacheOperation> parseCacheAnnotations(DefaultCacheConfig cachingConfig, AnnotatedElement ae) {
        Set cachings;
        Set puts;
        Set evicts;
        Collection<CacheOperation> ops = null;
        Set cacheables = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)ae, Cacheable.class);
        if (!cacheables.isEmpty()) {
            ops = this.lazyInit(ops);
            for (Object cacheable : cacheables) {
                ops.add((CacheOperation)this.parseCacheableAnnotation(ae, cachingConfig, (Cacheable)cacheable));
            }
        }
        if (!(evicts = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)ae, CacheEvict.class)).isEmpty()) {
            ops = this.lazyInit(ops);
            for (Object evict : evicts) {
                ops.add((CacheOperation)this.parseEvictAnnotation(ae, cachingConfig, (CacheEvict)evict));
            }
        }
        if (!(puts = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)ae, CachePut.class)).isEmpty()) {
            ops = this.lazyInit(ops);
            for (CachePut put : puts) {
                ops.add(this.parsePutAnnotation(ae, cachingConfig, put));
            }
        }
        if (!(cachings = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)ae, Caching.class)).isEmpty()) {
            ops = this.lazyInit(ops);
            for (Caching caching : cachings) {
                Collection<CacheOperation> cachingOps = this.parseCachingAnnotation(ae, cachingConfig, caching);
                if (cachingOps == null) continue;
                ops.addAll(cachingOps);
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops) {
        return ops != null ? ops : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Cacheable cacheable) {
        CacheableOperation.Builder builder = new CacheableOperation.Builder();
        builder.setName(ae.toString());
        builder.setCacheNames(cacheable.cacheNames());
        builder.setCondition(cacheable.condition());
        builder.setUnless(cacheable.unless());
        builder.setKey(cacheable.key());
        builder.setKeyGenerator(cacheable.keyGenerator());
        builder.setCacheManager(cacheable.cacheManager());
        builder.setCacheResolver(cacheable.cacheResolver());
        builder.setSync(cacheable.sync());
        defaultConfig.applyDefault((CacheOperation.Builder)builder);
        CacheableOperation op = builder.build();
        this.validateCacheOperation(ae, (CacheOperation)op);
        return op;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CacheEvict cacheEvict) {
        CacheEvictOperation.Builder builder = new CacheEvictOperation.Builder();
        builder.setName(ae.toString());
        builder.setCacheNames(cacheEvict.cacheNames());
        builder.setCondition(cacheEvict.condition());
        builder.setKey(cacheEvict.key());
        builder.setKeyGenerator(cacheEvict.keyGenerator());
        builder.setCacheManager(cacheEvict.cacheManager());
        builder.setCacheResolver(cacheEvict.cacheResolver());
        builder.setCacheWide(cacheEvict.allEntries());
        builder.setBeforeInvocation(cacheEvict.beforeInvocation());
        defaultConfig.applyDefault((CacheOperation.Builder)builder);
        CacheEvictOperation op = builder.build();
        this.validateCacheOperation(ae, (CacheOperation)op);
        return op;
    }

    CacheOperation parsePutAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CachePut cachePut) {
        CachePutOperation.Builder builder = new CachePutOperation.Builder();
        builder.setName(ae.toString());
        builder.setCacheNames(cachePut.cacheNames());
        builder.setCondition(cachePut.condition());
        builder.setUnless(cachePut.unless());
        builder.setKey(cachePut.key());
        builder.setKeyGenerator(cachePut.keyGenerator());
        builder.setCacheManager(cachePut.cacheManager());
        builder.setCacheResolver(cachePut.cacheResolver());
        defaultConfig.applyDefault((CacheOperation.Builder)builder);
        CachePutOperation op = builder.build();
        this.validateCacheOperation(ae, (CacheOperation)op);
        return op;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Caching caching) {
        Object[] cachePuts;
        Object[] cacheEvicts;
        Collection<CacheOperation> ops = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty((Object[])cacheables)) {
            ops = this.lazyInit(ops);
            for (Object cacheable : cacheables) {
                ops.add((CacheOperation)this.parseCacheableAnnotation(ae, defaultConfig, (Cacheable)cacheable));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(cacheEvicts = caching.evict()))) {
            ops = this.lazyInit(ops);
            for (Object cacheEvict : cacheEvicts) {
                ops.add((CacheOperation)this.parseEvictAnnotation(ae, defaultConfig, (CacheEvict)cacheEvict));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(cachePuts = caching.put()))) {
            ops = this.lazyInit(ops);
            for (Object cachePut : cachePuts) {
                ops.add(this.parsePutAnnotation(ae, defaultConfig, (CachePut)cachePut));
            }
        }
        return ops;
    }

    DefaultCacheConfig getDefaultCacheConfig(Class<?> target) {
        CacheConfig annotation = (CacheConfig)AnnotatedElementUtils.getMergedAnnotation(target, CacheConfig.class);
        if (annotation != null) {
            return new DefaultCacheConfig(annotation.cacheNames(), annotation.keyGenerator(), annotation.cacheManager(), annotation.cacheResolver());
        }
        return new DefaultCacheConfig();
    }

    private void validateCacheOperation(AnnotatedElement ae, CacheOperation operation) {
        if (StringUtils.hasText((String)operation.getKey()) && StringUtils.hasText((String)operation.getKeyGenerator())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'key' and 'keyGenerator' attributes have been set. These attributes are mutually exclusive: either set the SpEL expression used tocompute the key at runtime or set the name of the KeyGenerator bean to use.");
        }
        if (StringUtils.hasText((String)operation.getCacheManager()) && StringUtils.hasText((String)operation.getCacheResolver())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'cacheManager' and 'cacheResolver' attributes have been set. These attributes are mutually exclusive: the cache manager is used to configure adefault cache resolver if none is set. If a cache resolver is set, the cache managerwon't be used.");
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof FixUseSupperClassAnnotationParser;
    }

    public int hashCode() {
        return FixUseSupperClassAnnotationParser.class.hashCode();
    }

    static class DefaultCacheConfig {
        private final String[] cacheNames;
        private final String keyGenerator;
        private final String cacheManager;
        private final String cacheResolver;

        public DefaultCacheConfig() {
            this(null, null, null, null);
        }

        private DefaultCacheConfig(String[] cacheNames, String keyGenerator, String cacheManager, String cacheResolver) {
            this.cacheNames = cacheNames;
            this.keyGenerator = keyGenerator;
            this.cacheManager = cacheManager;
            this.cacheResolver = cacheResolver;
        }

        public void applyDefault(CacheOperation.Builder builder) {
            if (builder.getCacheNames().isEmpty() && this.cacheNames != null) {
                builder.setCacheNames(this.cacheNames);
            }
            if (!StringUtils.hasText((String)builder.getKey()) && !StringUtils.hasText((String)builder.getKeyGenerator()) && StringUtils.hasText((String)this.keyGenerator)) {
                builder.setKeyGenerator(this.keyGenerator);
            }
            if (!StringUtils.hasText((String)builder.getCacheManager()) && !StringUtils.hasText((String)builder.getCacheResolver())) {
                if (StringUtils.hasText((String)this.cacheResolver)) {
                    builder.setCacheResolver(this.cacheResolver);
                } else if (StringUtils.hasText((String)this.cacheManager)) {
                    builder.setCacheManager(this.cacheManager);
                }
            }
        }
    }
}

