/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.hswebframework.web.async.AsyncJobException;
import org.hswebframework.web.async.BatchAsyncJobContainer;
import org.hswebframework.web.async.TransactionSupportJob;
import org.hswebframework.web.async.TransactionSupportJobWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBatchAsyncJobContainer
implements BatchAsyncJobContainer {
    private ExecutorService executorService;
    private TransactionSupportJobWrapper translationSupportJobWrapper;
    private static final Logger logger = LoggerFactory.getLogger(TransactionBatchAsyncJobContainer.class);
    private List<Exception> exceptions = new ArrayList<Exception>();
    private AtomicInteger failCounter = new AtomicInteger();
    private AtomicInteger transactionJobOverCounter = new AtomicInteger(0);
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private List<Future> futures = new ArrayList<Future>();
    private AtomicInteger transactionJobNumber = new AtomicInteger(0);
    private volatile boolean shutdown = false;

    public TransactionBatchAsyncJobContainer(ExecutorService executorService, TransactionSupportJobWrapper translationSupportJobWrapper) {
        this.executorService = executorService;
        this.translationSupportJobWrapper = translationSupportJobWrapper;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public <V> BatchAsyncJobContainer submit(Callable<V> callable, boolean enableTransaction) {
        if (this.shutdown) {
            logger.warn("TransactionBatchAsyncJobContainer is shutdown, fail job number :{}", (Object)this.failCounter.get());
            return this;
        }
        if (!enableTransaction) {
            if (logger.isDebugEnabled()) {
                logger.debug("submit not transaction support job");
            }
            this.futures.add(this.executorService.submit(() -> {
                if (this.shutdown) {
                    return null;
                }
                return callable.call();
            }));
            return this;
        }
        int tmpJobFlag = this.transactionJobNumber.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("submit transaction support job {}", (Object)this.transactionJobNumber);
        }
        TransactionSupportJob translationJob = this.translationSupportJobWrapper.wrapper(callable);
        Callable<Object> proxy = () -> {
            Object value = null;
            try {
                if (this.failCounter.get() > 0 || this.shutdown) {
                    Object var4_4 = null;
                    return var4_4;
                }
                value = translationJob.call();
                this.transactionJobOverCounter.incrementAndGet();
                if (logger.isDebugEnabled()) {
                    logger.debug("transaction support job {} success,wait...", (Object)tmpJobFlag);
                }
                this.countDownLatch.await();
                if (this.failCounter.get() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("transaction support job {} success,but other job failed, do rollback only!", (Object)tmpJobFlag);
                    }
                    translationJob.rollBackOnly();
                } else if (logger.isDebugEnabled()) {
                    logger.debug("transaction support job {} success,commit.", (Object)tmpJobFlag);
                }
                translationJob.commit();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                this.failCounter.incrementAndGet();
                logger.warn("transaction support job {} fail.", (Object)tmpJobFlag, (Object)e);
            }
            finally {
                this.transactionJobOverCounter.incrementAndGet();
            }
            return value;
        };
        this.futures.add(this.executorService.submit(proxy));
        return this;
    }

    @Override
    public List<Object> getResult() throws Exception {
        while (this.transactionJobOverCounter.get() != this.transactionJobNumber.get() && this.failCounter.get() == 0) {
            Thread.sleep(50L);
        }
        this.countDownLatch.countDown();
        List<Object> results = this.futures.stream().map(this::getValue).collect(Collectors.toList());
        if (!this.exceptions.isEmpty()) {
            throw new AsyncJobException(this.exceptions);
        }
        return results;
    }

    private Object getValue(Future future) {
        if (future == null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            return null;
        }
    }

    @Override
    public BatchAsyncJobContainer cancel() {
        this.shutdown = true;
        return this;
    }
}

