/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.async;

import java.util.concurrent.Callable;
import org.hswebframework.web.async.TransactionSupportJob;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionSupportJob<V>
implements TransactionSupportJob<V> {
    private TransactionStatus transactionStatus;
    private TransactionTemplate transactionTemplate;
    private boolean rollback = false;
    private Callable<V> target;

    public SpringTransactionSupportJob(TransactionTemplate transactionTemplate, Callable<V> job) {
        this.transactionTemplate = transactionTemplate;
        this.target = job;
    }

    @Override
    public void rollBackOnly() {
        this.rollback = true;
    }

    @Override
    public void commit() {
        if (this.transactionStatus != null) {
            if (this.rollback) {
                this.transactionTemplate.getTransactionManager().rollback(this.transactionStatus);
            } else {
                this.transactionTemplate.getTransactionManager().commit(this.transactionStatus);
            }
        }
    }

    @Override
    public V call() throws Exception {
        this.transactionStatus = this.transactionTemplate.getTransactionManager().getTransaction((TransactionDefinition)this.transactionTemplate);
        if (this.rollback) {
            this.transactionStatus.setRollbackOnly();
        }
        return this.target.call();
    }
}

