/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hswebframework.web.async.AsyncJobService;
import org.hswebframework.web.async.SpringTransactionSupportJobWrapper;
import org.hswebframework.web.async.TransactionSupportAsyncJobService;
import org.hswebframework.web.async.TransactionSupportJobWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingBean(value={AsyncJobService.class})
public class AsyncJobServiceAutoConfiguration {
    @Value(value="${hsweb.async.job.maxThreadPoolSize:-1}")
    private int maxThreadPoolSize = -1;

    @Bean
    @ConditionalOnMissingBean(value={ExecutorService.class})
    public ExecutorService executorService() {
        if (this.maxThreadPoolSize == -1) {
            this.maxThreadPoolSize = Runtime.getRuntime().availableProcessors() * 50;
        }
        return Executors.newFixedThreadPool(this.maxThreadPoolSize);
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionSupportJobWrapper.class})
    public TransactionSupportJobWrapper transactionSupportJobWrapper() {
        return new SpringTransactionSupportJobWrapper();
    }

    @Bean
    public AsyncJobService asyncJobService(ExecutorService executorService, TransactionSupportJobWrapper transactionSupportJobWrapper) {
        TransactionSupportAsyncJobService asyncJobService = new TransactionSupportAsyncJobService();
        asyncJobService.setTranslationSupportJobWrapper(transactionSupportJobWrapper);
        asyncJobService.setExecutorService(executorService);
        return asyncJobService;
    }
}

