/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class ThreadLocalUtils {
    private static final ThreadLocal<Map<String, Object>> local = ThreadLocal.withInitial(HashMap::new);

    private ThreadLocalUtils() {
    }

    public static Map<String, Object> getAll() {
        return new HashMap<String, Object>(local.get());
    }

    public static <T> T put(String key, T value) {
        local.get().put(key, value);
        return value;
    }

    public static void remove(String key) {
        local.get().remove(key);
    }

    public static void clear() {
        local.remove();
    }

    public static <T> T get(String key) {
        return (T)local.get().get(key);
    }

    public static <T> T get(String key, Supplier<T> supplierOnNull) {
        return (T)local.get().computeIfAbsent(key, k -> supplierOnNull.get());
    }

    public static <T> T getAndRemove(String key) {
        try {
            T t = ThreadLocalUtils.get(key);
            return t;
        }
        finally {
            ThreadLocalUtils.remove(key);
        }
    }
}

