/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class Lists {
    public static <V> ListBuilder<V> buildList(Supplier<List<V>> supplier) {
        return Lists.buildList(supplier.get());
    }

    public static <V> ListBuilder<V> buildList(V ... array) {
        return Lists.buildList(array.length == 0 ? new ArrayList() : new ArrayList<V>(Arrays.asList(array)));
    }

    public static <V> ListBuilder<V> buildList(List<V> target) {
        return new ListBuilder(target);
    }

    public static class ListBuilder<V> {
        private final List<V> target;

        private ListBuilder(List<V> target) {
            Objects.requireNonNull(target);
            this.target = target;
        }

        public ListBuilder<V> add(V value, V ... more) {
            this.target.add(value);
            if (more.length > 0) {
                this.addAll(Arrays.asList(more));
            }
            return this;
        }

        public ListBuilder<V> addAll(Collection<V> value) {
            this.target.addAll(value);
            return this;
        }

        public List<V> get() {
            return this.target;
        }
    }
}

