/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.expands.script.engine.ExecuteResult;

public class ExpressionUtils {
    private static final Pattern PATTERN = Pattern.compile("(?<=\\$\\{)(.+?)(?=})");

    public static Map<String, Object> getDefaultVar() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> getDefaultVar(Map<String, Object> var) {
        Map<String, Object> vars = ExpressionUtils.getDefaultVar();
        vars.putAll(var);
        return vars;
    }

    public static String analytical(String expression, String language) throws Exception {
        return ExpressionUtils.analytical(expression, new HashMap<String, Object>(), language);
    }

    public static String analytical(String expression, Map<String, Object> vars, String language) throws Exception {
        Matcher matcher = PATTERN.matcher(expression);
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)language);
        if (engine == null) {
            return expression;
        }
        vars = new HashMap<String, Object>(vars);
        vars.putAll(ExpressionUtils.getDefaultVar());
        while (matcher.find()) {
            ExecuteResult result;
            String real_expression = matcher.group();
            String e_id = String.valueOf(real_expression.hashCode());
            if (!engine.compiled(e_id)) {
                engine.compile(e_id, real_expression);
            }
            if (!(result = engine.execute(e_id, vars)).isSuccess()) {
                throw new RuntimeException(result.getMessage(), result.getException());
            }
            String obj = String.valueOf(result.get());
            expression = expression.replace("${" + real_expression + "}", obj);
        }
        return expression;
    }
}

