/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.LogicalDeleteEntity;
import org.hswebframework.web.commons.entity.RecordCreationEntity;
import org.hswebframework.web.commons.entity.RecordModifierEntity;
import org.hswebframework.web.commons.entity.events.EntityCreatedEvent;
import org.hswebframework.web.commons.entity.events.EntityModifyEvent;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.AbstractService;
import org.hswebframework.web.service.DefaultLogicPrimaryKeyValidator;
import org.hswebframework.web.service.GenericService;
import org.hswebframework.web.service.GenericsPayloadApplicationEvent;
import org.hswebframework.web.validator.group.CreateGroup;
import org.hswebframework.web.validator.group.UpdateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional(rollbackFor={Throwable.class})
public abstract class GenericEntityService<E extends GenericEntity<PK>, PK>
extends AbstractService<E, PK>
implements GenericService<E, PK> {
    protected ApplicationEventPublisher eventPublisher;

    protected abstract IDGenerator<PK> getIDGenerator();

    @Autowired(required=false)
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void init() {
        if (this.logicPrimaryKeyValidator instanceof DefaultLogicPrimaryKeyValidator) {
            DefaultLogicPrimaryKeyValidator.registerQuerySuppiler(this.getEntityInstanceType(), bean -> (Query)this.createQuery().not("id", bean.getId()));
        }
    }

    @Override
    public E deleteByPk(PK pk) {
        E old = this.selectByPk(pk);
        if (old == null) {
            return null;
        }
        if (old instanceof LogicalDeleteEntity) {
            LogicalDeleteEntity deleteEntity = (LogicalDeleteEntity)old;
            deleteEntity.setDeleted(true);
            deleteEntity.setDeleteTime(Long.valueOf(System.currentTimeMillis()));
            ((Update)this.createUpdate().set(() -> ((LogicalDeleteEntity)deleteEntity).getDeleted()).set(() -> ((LogicalDeleteEntity)deleteEntity).getDeleteTime()).where("id", pk)).exec();
        } else if (!this.physicalDeleteByPk(pk)) {
            this.logger.warn("\u7269\u7406\u5220\u9664\u6570\u636e\u5931\u8d25,\u4e3b\u952e:{}", pk);
        }
        return old;
    }

    protected boolean physicalDeleteByPk(PK pk) {
        return this.getDao().deleteByPk(pk) > 0;
    }

    protected boolean pushModifyEvent() {
        return RecordModifierEntity.class.isAssignableFrom(this.entityType);
    }

    protected boolean pushCreatedEvent() {
        return RecordCreationEntity.class.isAssignableFrom(this.entityType);
    }

    public int updateByPk(PK pk, E entity) {
        Assert.notNull(pk, (String)"primary key can not be null");
        Assert.hasText((String)String.valueOf(pk), (String)"primary key can not be null");
        Assert.notNull(entity, (String)"entity can not be null");
        entity.setId(pk);
        this.tryValidate(entity, UpdateGroup.class);
        if (this.eventPublisher != null && this.pushModifyEvent()) {
            E old = this.selectByPk(pk);
            this.eventPublisher.publishEvent(new GenericsPayloadApplicationEvent<EntityModifyEvent>(this, new EntityModifyEvent(old, entity, this.getEntityType()), this.getEntityType()));
        }
        return ((Update)((Update)this.createUpdate(entity).when(entity instanceof RecordCreationEntity, update -> update.and().excludes(new String[]{((RecordCreationEntity)entity).getCreatorIdProperty(), "createTime"}))).where("id", pk)).exec();
    }

    protected int updateByPk(E entity) {
        return this.updateByPk((PK)entity.getId(), entity);
    }

    public int updateByPk(List<E> data) {
        return data.stream().map(this::updateByPk).reduce(Math::addExact).orElse(0);
    }

    public PK saveOrUpdate(E entity) {
        if (this.dataExisted(entity)) {
            this.updateByPk(entity);
        } else {
            this.insert(entity);
        }
        return (PK)entity.getId();
    }

    protected boolean dataExisted(E entity) {
        if (null != this.logicPrimaryKeyValidator) {
            this.logicPrimaryKeyValidator.validate(entity, new Class[0]).ifError(result -> entity.setId(((GenericEntity)result.getData()).getId()));
        }
        return null != entity.getId() && null != this.selectByPk((PK)entity.getId());
    }

    public PK insert(E entity) {
        if (!StringUtils.isEmpty((Object)entity.getId())) {
            if (entity.getId() instanceof String && !StringUtils.isEmpty((Object)entity.getId())) {
                this.tryValidateProperty(entity.getId().toString().matches("[a-zA-Z0-9_\\-]+"), "id", "\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf,\u548c-\u7ec4\u6210");
            }
            this.tryValidateProperty(this.selectByPk((PK)entity.getId()) == null, "id", entity.getId() + "\u5df2\u5b58\u5728");
        }
        if (StringUtils.isEmpty((Object)entity.getId()) && this.getIDGenerator() != null) {
            entity.setId(this.getIDGenerator().generate());
        }
        if (entity instanceof RecordCreationEntity) {
            ((RecordCreationEntity)entity).setCreateTimeNow();
        }
        this.tryValidate(entity, CreateGroup.class);
        this.getDao().insert(entity);
        if (this.eventPublisher != null && this.pushCreatedEvent()) {
            this.eventPublisher.publishEvent(new GenericsPayloadApplicationEvent<EntityCreatedEvent>(this, new EntityCreatedEvent(entity, this.getEntityType()), this.getEntityType()));
        }
        return (PK)entity.getId();
    }

    @Transactional(readOnly=true)
    public E selectByPk(PK pk) {
        if (StringUtils.isEmpty(pk)) {
            return null;
        }
        return (E)((GenericEntity)((Query)this.createQuery().where("id", pk)).single());
    }

    @Transactional(readOnly=true)
    public List<E> selectByPk(List<PK> id) {
        if (CollectionUtils.isEmpty(id)) {
            return new ArrayList();
        }
        return ((Query)((Query)this.createQuery().where()).in("id", id)).listNoPaging();
    }
}

