/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.util.ArrayList;
import java.util.List;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.dao.dynamic.QueryByEntityDao;
import org.hswebframework.web.service.QueryByEntityService;
import org.springframework.transaction.annotation.Transactional;

public interface DefaultQueryByEntityService<E>
extends QueryByEntityService<E> {
    public QueryByEntityDao<E> getDao();

    default public PagerResult<E> selectPager(Entity param) {
        QueryParamEntity entity;
        PagerResult pagerResult = new PagerResult();
        if (param instanceof QueryParamEntity && !(entity = (QueryParamEntity)param).isPaging()) {
            pagerResult.setData(this.getDao().query(param));
            pagerResult.setTotal(pagerResult.getData().size());
            pagerResult.setPageIndex(entity.getThinkPageIndex());
            pagerResult.setPageSize(pagerResult.getData().size());
            return pagerResult;
        }
        int total = this.getDao().count(param);
        pagerResult.setTotal(total);
        if (param instanceof QueryParamEntity) {
            QueryParamEntity paramEntity = (QueryParamEntity)param;
            paramEntity.rePaging(total);
            pagerResult.setPageSize(paramEntity.getPageSize());
            pagerResult.setPageIndex(paramEntity.getThinkPageIndex());
        }
        if (total == 0) {
            pagerResult.setData(new ArrayList());
        } else {
            pagerResult.setData(this.select(param));
        }
        return pagerResult;
    }

    @Transactional(readOnly=true)
    default public List<E> select(Entity param) {
        if (param == null) {
            param = QueryParamEntity.empty();
        }
        return this.getDao().query(param);
    }

    @Transactional(readOnly=true)
    default public int count(Entity param) {
        if (param == null) {
            param = QueryParamEntity.empty();
        }
        return this.getDao().count(param);
    }

    @Transactional(readOnly=true)
    default public E selectSingle(Entity param) {
        List<E> list;
        if (param instanceof QueryParamEntity) {
            ((QueryParamEntity)param).doPaging(0, 1);
        }
        if ((list = this.select(param)).isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

