/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.dsl.Delete;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.utils.RandomUtil;
import org.hswebframework.web.commons.entity.TreeSortSupportEntity;
import org.hswebframework.web.commons.entity.TreeSupportEntity;
import org.hswebframework.web.dao.dynamic.DeleteByEntityDao;
import org.hswebframework.web.service.DefaultDSLDeleteService;
import org.hswebframework.web.service.GenericEntityService;
import org.hswebframework.web.service.TreeService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public abstract class AbstractTreeSortService<E extends TreeSortSupportEntity<PK>, PK>
extends GenericEntityService<E, PK>
implements TreeService<E, PK> {
    @Transactional(readOnly=true)
    public List<E> selectParentNode(PK childId) {
        AbstractTreeSortService.assertNotNull(childId);
        TreeSortSupportEntity old = (TreeSortSupportEntity)this.selectByPk(childId);
        if (null == old) {
            return new ArrayList();
        }
        return ((Query)((Query)this.createQuery().where()).and("path$like$reverse$startWith", (Object)old.getPath())).listNoPaging();
    }

    @Transactional(readOnly=true)
    public List<E> selectAllChildNode(PK parentId) {
        AbstractTreeSortService.assertNotNull(parentId);
        TreeSortSupportEntity old = (TreeSortSupportEntity)this.selectByPk(parentId);
        if (null == old) {
            return new ArrayList();
        }
        return ((Query)((Query)this.createQuery().where()).like$("path", (Object)old.getPath())).listNoPaging();
    }

    @Transactional(readOnly=true)
    public List<E> selectChildNode(PK parentId) {
        AbstractTreeSortService.assertNotNull(parentId);
        return ((Query)this.createQuery().where("parentId", parentId)).listNoPaging();
    }

    protected PK createParentIdOnExists() {
        if (this.getPrimaryKeyType() == String.class) {
            return (PK)"-1";
        }
        return null;
    }

    protected void applyPath(E entity) {
        if (StringUtils.isEmpty((Object)entity.getParentId())) {
            if (entity.getSortIndex() == null) {
                entity.setSortIndex(Long.valueOf(0L));
            }
            entity.setParentId(this.createParentIdOnExists());
            entity.setLevel(Integer.valueOf(0));
            entity.setPath(RandomUtil.randomChar((int)4));
            return;
        }
        if (!StringUtils.isEmpty((Object)entity.getPath())) {
            return;
        }
        TreeSortSupportEntity parent = (TreeSortSupportEntity)this.selectByPk(entity.getParentId());
        if (null == parent) {
            if (entity.getSortIndex() == null) {
                entity.setSortIndex(Long.valueOf(0L));
            }
            entity.setParentId(this.createParentIdOnExists());
            entity.setPath(RandomUtil.randomChar((int)4));
            entity.setLevel(Integer.valueOf(0));
        } else {
            if (entity.getSortIndex() == null && parent.getSortIndex() != null) {
                entity.setSortIndex(Long.valueOf(parent.getSortIndex() * 10L));
            }
            entity.setPath(parent.getPath() + "-" + RandomUtil.randomChar((int)4));
            entity.setLevel(Integer.valueOf(entity.getPath().split("[-]").length));
        }
    }

    @Override
    public PK insert(E entity) {
        if (StringUtils.isEmpty((Object)entity.getId())) {
            entity.setId(this.getIDGenerator().generate());
        }
        this.applyPath(entity);
        ArrayList childrenList = new ArrayList();
        TreeSupportEntity.expandTree2List(entity, childrenList, this.getIDGenerator());
        childrenList.forEach(this::saveOrUpdateForSingle);
        return (PK)entity.getId();
    }

    public List<PK> insertBatch(Collection<E> data) {
        return data.stream().map(this::insert).collect(Collectors.toList());
    }

    public int updateBatch(Collection<E> data) {
        AbstractTreeSortService.assertNotNull(data);
        return data.stream().mapToInt(this::updateByPk).sum();
    }

    @Override
    public int updateByPk(E entity) {
        AbstractTreeSortService.assertNotNull(entity);
        ArrayList childrenList = new ArrayList();
        TreeSupportEntity.expandTree2List(entity, childrenList, this.getIDGenerator());
        childrenList.forEach(this::saveOrUpdateForSingle);
        return childrenList.size() + 1;
    }

    protected PK saveOrUpdateForSingle(E entity) {
        AbstractTreeSortService.assertNotNull(entity);
        Object id = entity.getId();
        if (StringUtils.isEmpty((Object)id) || this.selectByPk(id) == null) {
            if (StringUtils.isEmpty((Object)id)) {
                entity.setId(this.getIDGenerator().generate());
            }
            this.applyPath(entity);
            return super.insert(entity);
        }
        super.updateByPk(entity);
        return (PK)id;
    }

    @Override
    public E deleteByPk(PK id) {
        TreeSortSupportEntity old = (TreeSortSupportEntity)this.selectByPk(id);
        AbstractTreeSortService.assertNotNull(old);
        if (StringUtils.isEmpty((Object)old.getPath())) {
            this.getDao().deleteByPk(id);
        } else {
            ((Delete)((Delete)DefaultDSLDeleteService.createDelete((DeleteByEntityDao)this.getDao()).where()).like$("path", (Object)old.getPath())).exec();
        }
        return (E)old;
    }
}

