/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.dsl.Update;
import org.hswebframework.web.commons.entity.GenericEntity;
import org.hswebframework.web.commons.entity.RecordCreationEntity;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.service.AbstractService;
import org.hswebframework.web.service.DefaultLogicPrimaryKeyValidator;
import org.hswebframework.web.service.GenericService;
import org.hswebframework.web.validator.group.CreateGroup;
import org.hswebframework.web.validator.group.UpdateGroup;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Transactional(rollbackFor={Throwable.class})
public abstract class GenericEntityService<E extends GenericEntity<PK>, PK>
extends AbstractService<E, PK>
implements GenericService<E, PK> {
    protected abstract IDGenerator<PK> getIDGenerator();

    @PostConstruct
    public void init() {
        if (null != this.logicPrimaryKeyValidator && this.logicPrimaryKeyValidator instanceof DefaultLogicPrimaryKeyValidator) {
            DefaultLogicPrimaryKeyValidator.registerQuerySuppiler(this.getEntityInstanceType(), bean -> (Query)this.createQuery().not("id", bean.getId()));
        }
    }

    @Override
    public E deleteByPk(PK pk) {
        Assert.notNull(pk, (String)"parameter can not be null");
        E old = this.selectByPk(pk);
        this.getDao().deleteByPk(pk);
        return old;
    }

    public int updateByPk(PK pk, E entity) {
        Assert.notNull(pk, (String)"primary key can not be null");
        Assert.notNull(entity, (String)"entity can not be null");
        entity.setId(pk);
        this.tryValidate(entity, UpdateGroup.class);
        return ((Update)((Update)this.createUpdate(entity).when(entity instanceof RecordCreationEntity, update -> update.and().excludes(new String[]{"creatorId", "createTime"}))).where("id", pk)).exec();
    }

    protected int updateByPk(E entity) {
        return this.updateByPk((PK)entity.getId(), entity);
    }

    public int updateByPk(List<E> data) {
        return data.stream().map(this::updateByPk).reduce(Math::addExact).orElse(0);
    }

    public PK saveOrUpdate(E entity) {
        if (this.dataExisted(entity)) {
            this.updateByPk(entity);
        } else {
            this.insert(entity);
        }
        return (PK)entity.getId();
    }

    protected boolean dataExisted(E entity) {
        if (null != this.logicPrimaryKeyValidator) {
            this.logicPrimaryKeyValidator.validate(entity, new Class[0]).ifError(result -> entity.setId(((GenericEntity)result.getData()).getId()));
        }
        return null != entity.getId() && null != this.selectByPk((PK)entity.getId());
    }

    public PK insert(E entity) {
        if (entity.getId() != null) {
            if (entity.getId() instanceof String && !StringUtils.isEmpty((Object)entity.getId())) {
                this.tryValidateProperty(entity.getId().toString().matches("[a-zA-Z0-9_\\-]+"), "id", "\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf,\u548c-\u7ec4\u6210");
            }
            this.tryValidateProperty(this.selectByPk((PK)entity.getId()) == null, "id", entity.getId() + "\u5df2\u5b58\u5728");
        }
        if (entity.getId() == null && this.getIDGenerator() != null) {
            entity.setId(this.getIDGenerator().generate());
        }
        if (entity instanceof RecordCreationEntity) {
            ((RecordCreationEntity)entity).setCreateTimeNow();
        }
        this.tryValidate(entity, CreateGroup.class);
        this.getDao().insert(entity);
        return (PK)entity.getId();
    }

    @Transactional(readOnly=true)
    public E selectByPk(PK pk) {
        if (null == pk) {
            return null;
        }
        return (E)((GenericEntity)((Query)this.createQuery().where("id", pk)).single());
    }

    @Transactional(readOnly=true)
    public List<E> selectByPk(List<PK> id) {
        if (id == null || id.isEmpty()) {
            return new ArrayList();
        }
        return ((Query)((Query)this.createQuery().where()).in("id", id)).listNoPaging();
    }
}

