/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.validator.LogicPrimaryKey;
import org.hswebframework.web.validator.LogicPrimaryKeyValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DefaultLogicPrimaryKeyValidator
implements LogicPrimaryKeyValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogicPrimaryKeyValidator.class);
    private static final Map<Class, Map<Class, Validator>> validatorCache = new HashMap<Class, Map<Class, Validator>>();
    private static final DefaultLogicPrimaryKeyValidator instrance = new DefaultLogicPrimaryKeyValidator();
    private static final Validator ALWAYS_PASSED_VALIDATOR = bean -> LogicPrimaryKeyValidator.Result.passed();

    protected DefaultLogicPrimaryKeyValidator() {
    }

    public static DefaultLogicPrimaryKeyValidator getInstrance() {
        return instrance;
    }

    public static <T> void registerQuerySuppiler(Class<T> type, Function<T, Query<T, QueryParamEntity>> querySupplier) {
        validatorCache.computeIfAbsent(type, instrance::createValidator).values().stream().filter(DefaultValidator.class::isInstance).map(DefaultValidator.class::cast).forEach(validator -> ((DefaultValidator)validator).querySupplier = querySupplier);
    }

    public LogicPrimaryKeyValidator.Result validate(Object bean, Class ... groups) {
        Class target = ClassUtils.getUserClass((Object)bean);
        LogicPrimaryKeyValidator.Result result = null != groups && groups.length > 0 ? Arrays.stream(groups).map(group -> validatorCache.computeIfAbsent(target, this::createValidator).getOrDefault(group, ALWAYS_PASSED_VALIDATOR).doValidate(bean)).filter(LogicPrimaryKeyValidator.Result::isError).findFirst().orElseGet(LogicPrimaryKeyValidator.Result::passed) : validatorCache.computeIfAbsent(target, this::createValidator).getOrDefault(Void.class, ALWAYS_PASSED_VALIDATOR).doValidate(bean);
        return result;
    }

    protected Map<Class, Validator> createValidator(Class target) {
        HashMap<String, LogicPrimaryKey> keys = new HashMap<String, LogicPrimaryKey>();
        ReflectionUtils.doWithFields((Class)target, field -> {
            LogicPrimaryKey primaryKey = field.getAnnotation(LogicPrimaryKey.class);
            if (primaryKey != null) {
                keys.put(field.getName(), primaryKey);
            }
        });
        Class[] tempClass = new Class[]{target};
        LogicPrimaryKey classAnn = null;
        Class[] empty = new Class[]{};
        while (tempClass.length != 0) {
            for (Class group : tempClass) {
                classAnn = (LogicPrimaryKey)AnnotationUtils.findAnnotation((Class)group, LogicPrimaryKey.class);
                if (null != classAnn) {
                    if (classAnn.value().length > 0) {
                        for (String field2 : classAnn.value()) {
                            keys.put(field2, classAnn);
                        }
                        tempClass = empty;
                        continue;
                    }
                    tempClass = classAnn.groups();
                    if (tempClass.length != 1 || tempClass[0] != Void.class) continue;
                    log.warn("\u7c7b{}\u7684\u6ce8\u89e3{}\u65e0\u6548,\u8bf7\u8bbe\u7f6evalue\u5c5e\u6027\u6216\u8005group\u5c5e\u6027", (Object)classAnn, (Object)tempClass);
                    continue;
                }
                tempClass = empty;
            }
        }
        if (keys.isEmpty()) {
            return new HashMap<Class, Validator>();
        }
        return keys.entrySet().stream().flatMap(entry -> Stream.of(((LogicPrimaryKey)entry.getValue()).groups()).flatMap(group -> Optional.ofNullable(((LogicPrimaryKey)entry.getValue()).value()).map(Arrays::asList).filter(CollectionUtils::isNotEmpty).orElse(Arrays.asList((String)entry.getKey())).stream().map(field -> LogicPrimaryKeyField.builder().field((String)field).termType(((LogicPrimaryKey)entry.getValue()).termType()).condition(((LogicPrimaryKey)entry.getValue()).condition()).matchNullOrEmpty(((LogicPrimaryKey)entry.getValue()).matchNullOrEmpty()).group((Class)group).build()))).collect(Collectors.groupingBy(LogicPrimaryKeyField::getGroup, Collectors.collectingAndThen(Collectors.mapping(Function.identity(), Collectors.toSet()), list -> DefaultValidator.builder().infos((Set<LogicPrimaryKeyField>)list).targetType(target).build())));
    }

    private static class LogicPrimaryKeyField {
        private String field;
        private String condition;
        private boolean matchNullOrEmpty;
        private String termType;
        private Class group;

        public int hashCode() {
            return this.field.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogicPrimaryKeyField) {
                return this.hashCode() == obj.hashCode();
            }
            return false;
        }

        @ConstructorProperties(value={"field", "condition", "matchNullOrEmpty", "termType", "group"})
        LogicPrimaryKeyField(String field, String condition, boolean matchNullOrEmpty, String termType, Class group) {
            this.field = field;
            this.condition = condition;
            this.matchNullOrEmpty = matchNullOrEmpty;
            this.termType = termType;
            this.group = group;
        }

        public static LogicPrimaryKeyFieldBuilder builder() {
            return new LogicPrimaryKeyFieldBuilder();
        }

        public String getField() {
            return this.field;
        }

        public String getCondition() {
            return this.condition;
        }

        public boolean isMatchNullOrEmpty() {
            return this.matchNullOrEmpty;
        }

        public String getTermType() {
            return this.termType;
        }

        public Class getGroup() {
            return this.group;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public void setMatchNullOrEmpty(boolean matchNullOrEmpty) {
            this.matchNullOrEmpty = matchNullOrEmpty;
        }

        public void setTermType(String termType) {
            this.termType = termType;
        }

        public void setGroup(Class group) {
            this.group = group;
        }

        public static class LogicPrimaryKeyFieldBuilder {
            private String field;
            private String condition;
            private boolean matchNullOrEmpty;
            private String termType;
            private Class group;

            LogicPrimaryKeyFieldBuilder() {
            }

            public LogicPrimaryKeyFieldBuilder field(String field) {
                this.field = field;
                return this;
            }

            public LogicPrimaryKeyFieldBuilder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public LogicPrimaryKeyFieldBuilder matchNullOrEmpty(boolean matchNullOrEmpty) {
                this.matchNullOrEmpty = matchNullOrEmpty;
                return this;
            }

            public LogicPrimaryKeyFieldBuilder termType(String termType) {
                this.termType = termType;
                return this;
            }

            public LogicPrimaryKeyFieldBuilder group(Class group) {
                this.group = group;
                return this;
            }

            public LogicPrimaryKeyField build() {
                return new LogicPrimaryKeyField(this.field, this.condition, this.matchNullOrEmpty, this.termType, this.group);
            }

            public String toString() {
                return "DefaultLogicPrimaryKeyValidator.LogicPrimaryKeyField.LogicPrimaryKeyFieldBuilder(field=" + this.field + ", condition=" + this.condition + ", matchNullOrEmpty=" + this.matchNullOrEmpty + ", termType=" + this.termType + ", group=" + this.group + ")";
            }
        }
    }

    static class DefaultValidator<T>
    implements Validator<T> {
        private Set<LogicPrimaryKeyField> infos = new HashSet<LogicPrimaryKeyField>();
        private Class<T> targetType;
        private volatile Function<T, Query<T, QueryParamEntity>> querySupplier;

        @Override
        public LogicPrimaryKeyValidator.Result doValidate(T bean) {
            if (this.querySupplier == null) {
                log.warn("\u672a\u8bbe\u7f6e\u67e5\u8be2\u51fd\u6570,\u4f60\u53ef\u4ee5\u5728\u670d\u52a1\u521d\u59cb\u5316\u7684\u65f6\u5019\u901a\u8fc7\u8c03\u7528DefaultLogicPrimaryKeyValidator.registerQuerySuppiler({},bean -> this.createQuery().not(\"id\", bean.getId()))\u8fdb\u884c\u8bbe\u7f6e", this.targetType);
                return LogicPrimaryKeyValidator.Result.passed();
            }
            Query<T, QueryParamEntity> query = this.querySupplier.apply(bean);
            Map mapBean = (Map)FastBeanCopier.copy(bean, new HashMap(), (String[])new String[0]);
            HashMap properties = new HashMap();
            for (LogicPrimaryKeyField info : this.infos) {
                String field = info.getField();
                Object value = mapBean.get(field);
                if (value == null) {
                    String[] nest;
                    Object nestObject;
                    String tmpField = field;
                    Object tmpValue = null;
                    Map tempMapBean = mapBean;
                    while (tmpValue == null && tmpField.contains(".") && (nestObject = tempMapBean.get((nest = tmpField.split("[.]", 2))[0])) != null) {
                        tempMapBean = nestObject instanceof Map ? (Map)nestObject : (Map)FastBeanCopier.copy(nestObject, new HashMap(), (String[])new String[0]);
                        tmpField = nest[1];
                        tmpValue = tempMapBean.get(tmpField);
                    }
                    value = tmpValue;
                }
                if (StringUtils.isEmpty(value)) {
                    if (info.matchNullOrEmpty) {
                        if (value == null) {
                            query.isNull(info.getField());
                        } else {
                            query.isEmpty(info.getField());
                        }
                    }
                } else {
                    String termType = StringUtils.isEmpty((Object)info.termType) ? "eq" : info.termType;
                    query.and(info.getField(), termType, value);
                }
                properties.put(info.getField(), value);
            }
            Object result = query.single();
            if (result != null) {
                LogicPrimaryKeyValidator.Result validateResult = new LogicPrimaryKeyValidator.Result();
                validateResult.setError(true);
                validateResult.setData(result);
                validateResult.setProperties(properties);
                return validateResult;
            }
            return LogicPrimaryKeyValidator.Result.passed();
        }

        @ConstructorProperties(value={"infos", "targetType", "querySupplier"})
        DefaultValidator(Set<LogicPrimaryKeyField> infos, Class<T> targetType, Function<T, Query<T, QueryParamEntity>> querySupplier) {
            this.infos = infos;
            this.targetType = targetType;
            this.querySupplier = querySupplier;
        }

        public static <T> DefaultValidatorBuilder<T> builder() {
            return new DefaultValidatorBuilder();
        }

        public static class DefaultValidatorBuilder<T> {
            private Set<LogicPrimaryKeyField> infos;
            private Class<T> targetType;
            private Function<T, Query<T, QueryParamEntity>> querySupplier;

            DefaultValidatorBuilder() {
            }

            public DefaultValidatorBuilder<T> infos(Set<LogicPrimaryKeyField> infos) {
                this.infos = infos;
                return this;
            }

            public DefaultValidatorBuilder<T> targetType(Class<T> targetType) {
                this.targetType = targetType;
                return this;
            }

            public DefaultValidatorBuilder<T> querySupplier(Function<T, Query<T, QueryParamEntity>> querySupplier) {
                this.querySupplier = querySupplier;
                return this;
            }

            public DefaultValidator<T> build() {
                return new DefaultValidator<T>(this.infos, this.targetType, this.querySupplier);
            }

            public String toString() {
                return "DefaultLogicPrimaryKeyValidator.DefaultValidator.DefaultValidatorBuilder(infos=" + this.infos + ", targetType=" + this.targetType + ", querySupplier=" + this.querySupplier + ")";
            }
        }
    }

    static interface Validator<T> {
        public LogicPrimaryKeyValidator.Result doValidate(T var1);
    }
}

