/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.service.oauth2;

import org.hswebframework.web.WebUtil;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestService;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Request;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Session;

public interface OAuth2ServiceSupport {
    public OAuth2RequestService getRequestService();

    public String getServiceId();

    public String getUriPrefix();

    public <E> Class<E> getEntityType();

    public <PK> Class<PK> getPrimaryKeyType();

    default public OAuth2Session createSession() {
        return this.getRequestService().create(this.getServiceId()).byClientCredentials();
    }

    default public OAuth2Request createRequest(String uri) {
        return this.createSession().request(this.getUriPrefix() + uri);
    }

    default public OAuth2Request createRequest(String uri, Object param) {
        return this.createSession().request(this.getUriPrefix() + uri).params(WebUtil.objectToHttpParameters((Object)param));
    }
}

