/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ApiModel(description="\u54cd\u5e94\u7ed3\u679c")
public class ResponseMessage<T>
implements Serializable {
    private static final long serialVersionUID = 8992436576262574064L;
    protected String message;
    protected T result;
    protected int status;
    private Long timestamp;
    private String code;
    private transient Map<Class<?>, Set<String>> includes;
    private transient Map<Class<?>, Set<String>> excludes;

    @ApiModelProperty(value="\u8c03\u7528\u7ed3\u679c\u6d88\u606f")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(value="\u72b6\u6001\u7801", required=true)
    public int getStatus() {
        return this.status;
    }

    @ApiModelProperty(value="\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e")
    public T getResult() {
        return this.result;
    }

    @ApiModelProperty(value="\u65f6\u95f4\u6233", required=true, dataType="Long")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(value="\u4e1a\u52a1\u4ee3\u7801")
    public String getCode() {
        return this.code;
    }

    public static <T> ResponseMessage<T> error(String message) {
        return ResponseMessage.error(500, message);
    }

    public static <T> ResponseMessage<T> error(int status, String message) {
        ResponseMessage<T> msg = new ResponseMessage<T>();
        msg.message = message;
        msg.status(status);
        return super.putTimeStamp();
    }

    public static <T> ResponseMessage<T> ok() {
        return ResponseMessage.ok(null);
    }

    private ResponseMessage<T> putTimeStamp() {
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public static <T> ResponseMessage<T> ok(T result) {
        return super.putTimeStamp().status(200);
    }

    public ResponseMessage<T> result(T result) {
        this.result = result;
        return this;
    }

    public ResponseMessage<T> code(String code) {
        this.code = code;
        return this;
    }

    public ResponseMessage<T> include(Class<?> type, String ... fields) {
        return this.include(type, Arrays.asList(fields));
    }

    public ResponseMessage<T> include(Class<?> type, Collection<String> fields) {
        if (this.includes == null) {
            this.includes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        fields.forEach(field -> {
            if (field.contains(".")) {
                String[] tmp = field.split("[.]", 2);
                try {
                    Field field1 = type.getDeclaredField(tmp[0]);
                    if (field1 != null) {
                        this.include(field1.getType(), tmp[1]);
                    }
                }
                catch (Exception exception) {}
            } else {
                this.getStringListFromMap(this.includes, type).add((String)field);
            }
        });
        return this;
    }

    public ResponseMessage<T> exclude(Class type, Collection<String> fields) {
        if (this.excludes == null) {
            this.excludes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        fields.forEach(field -> {
            if (field.contains(".")) {
                String[] tmp = field.split("[.]", 2);
                try {
                    Field field1 = type.getDeclaredField(tmp[0]);
                    if (field1 != null) {
                        this.exclude(field1.getType(), tmp[1]);
                    }
                }
                catch (Exception exception) {}
            } else {
                this.getStringListFromMap(this.excludes, type).add((String)field);
            }
        });
        return this;
    }

    public ResponseMessage<T> exclude(Collection<String> fields) {
        if (this.excludes == null) {
            this.excludes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        if (this.getResult() == null) {
            return this;
        }
        Class<?> type = this.getResult().getClass();
        this.exclude(type, fields);
        return this;
    }

    public ResponseMessage<T> include(Collection<String> fields) {
        if (this.includes == null) {
            this.includes = new HashMap();
        }
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        if (this.getResult() == null) {
            return this;
        }
        Class<?> type = this.getResult().getClass();
        this.include(type, fields);
        return this;
    }

    public ResponseMessage<T> exclude(Class type, String ... fields) {
        return this.exclude(type, Arrays.asList(fields));
    }

    public ResponseMessage<T> exclude(String ... fields) {
        return this.exclude(Arrays.asList(fields));
    }

    public ResponseMessage<T> include(String ... fields) {
        return this.include(Arrays.asList(fields));
    }

    protected Set<String> getStringListFromMap(Map<Class<?>, Set<String>> map, Class type) {
        return map.computeIfAbsent(type, k -> new HashSet());
    }

    public String toString() {
        return JSON.toJSONStringWithDateFormat((Object)this, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
    }

    public ResponseMessage<T> status(int status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(hidden=true)
    public Map<Class<?>, Set<String>> getExcludes() {
        return this.excludes;
    }

    @ApiModelProperty(hidden=true)
    public Map<Class<?>, Set<String>> getIncludes() {
        return this.includes;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

