/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller;

import io.swagger.annotations.ApiOperation;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Logical;
import org.hswebframework.web.commons.entity.RecordCreationEntity;
import org.hswebframework.web.commons.entity.RecordModifierEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.service.CreateEntityService;
import org.hswebframework.web.service.UpdateService;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public interface UpdateController<E, PK, M> {
    public <S extends UpdateService<E, PK> & CreateEntityService<E>> S getService();

    @Authorize(action={"update"})
    @PutMapping(path={"/{id}"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    default public ResponseMessage<Integer> updateByPrimaryKey(@PathVariable PK id, @RequestBody M data) {
        Object entity = this.modelToEntity(data, ((CreateEntityService)this.getService()).createEntity());
        if (entity instanceof RecordModifierEntity) {
            RecordModifierEntity creationEntity = (RecordModifierEntity)entity;
            creationEntity.setModifyTimeNow();
            creationEntity.setModifierId((String)Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null));
        }
        return ResponseMessage.ok(((UpdateService)((CreateEntityService)this.getService())).updateByPk(id, entity));
    }

    @Authorize(action={"update", "add"}, logical=Logical.AND)
    @PatchMapping
    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    default public ResponseMessage<PK> saveOrUpdate(@RequestBody M data) {
        RecordCreationEntity creationEntity;
        Object entity = this.modelToEntity(data, ((CreateEntityService)this.getService()).createEntity());
        if (entity instanceof RecordCreationEntity) {
            creationEntity = (RecordCreationEntity)entity;
            creationEntity.setCreateTimeNow();
            creationEntity.setCreatorId((String)Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null));
        }
        if (entity instanceof RecordModifierEntity) {
            creationEntity = (RecordModifierEntity)entity;
            creationEntity.setModifyTimeNow();
            creationEntity.setModifierId((String)Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null));
        }
        return ResponseMessage.ok(((UpdateService)((CreateEntityService)this.getService())).saveOrUpdate(entity));
    }

    @Authorize(ignore=true)
    public E modelToEntity(M var1, E var2);
}

