/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.Entity;
import org.hswebframework.web.commons.entity.PagerResult;
import org.hswebframework.web.commons.entity.param.QueryParamEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.service.QueryByEntityService;
import org.hswebframework.web.service.QueryService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public interface QueryController<E, PK, Q extends Entity> {
    @Authorize(ignore=true)
    public <T extends QueryByEntityService<E> & QueryService<E, PK>> T getService();

    @Authorize(action={"query"})
    @GetMapping
    @ApiOperation(value="\u6839\u636e\u52a8\u6001\u6761\u4ef6\u67e5\u8be2", responseReference="get")
    default public ResponseMessage<PagerResult<E>> list(Q param) {
        return ResponseMessage.ok(this.getService().selectPager(param));
    }

    @Authorize(action={"query"})
    @GetMapping(value={"/no-paging"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u52a8\u6001\u67e5\u8be2", responseReference="get")
    default public ResponseMessage<List<E>> listNoPaging(Q param) {
        if (param instanceof QueryParamEntity) {
            ((QueryParamEntity)param).setPaging(false);
        }
        return ResponseMessage.ok(this.getService().select(param));
    }

    @Authorize(action={"query"})
    @GetMapping(value={"/count"})
    @ApiOperation(value="\u6839\u636e\u52a8\u6001\u6761\u4ef6\u7edf\u8ba1", responseReference="get")
    default public ResponseMessage<Integer> count(Q param) {
        return ResponseMessage.ok(this.getService().count(param));
    }

    @Authorize(action={"get"})
    @GetMapping(path={"/{id:.+}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2")
    default public ResponseMessage<E> getByPrimaryKey(@PathVariable PK id) {
        return ResponseMessage.ok(QueryController.assertNotNull(((QueryService)this.getService()).selectByPk(id)));
    }

    @Authorize(action={"get"})
    @GetMapping(path={"/ids"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u591a\u6761\u8bb0\u5f55")
    default public ResponseMessage<List<E>> getByPrimaryKey(@RequestParam List<PK> ids) {
        return ResponseMessage.ok(QueryController.assertNotNull(((QueryService)this.getService()).selectByPk(ids)));
    }

    @Authorize(ignore=true)
    public static <T> T assertNotNull(T obj) {
        if (null == obj) {
            throw new NotFoundException("{data_not_exist}");
        }
        return obj;
    }
}

