/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.controller;

import io.swagger.annotations.ApiOperation;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.commons.entity.RecordCreationEntity;
import org.hswebframework.web.commons.entity.RecordModifierEntity;
import org.hswebframework.web.controller.message.ResponseMessage;
import org.hswebframework.web.service.CreateEntityService;
import org.hswebframework.web.service.InsertService;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public interface CreateController<E, PK, M> {
    @Authorize(ignore=true)
    public <S extends InsertService<E, PK> & CreateEntityService<E>> S getService();

    @Authorize(action={"add"})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="\u65b0\u589e")
    default public ResponseMessage<PK> add(@RequestBody M data) {
        RecordCreationEntity creationEntity;
        Object entity = this.modelToEntity(data, ((CreateEntityService)this.getService()).createEntity());
        if (entity instanceof RecordCreationEntity) {
            creationEntity = (RecordCreationEntity)entity;
            creationEntity.setCreateTimeNow();
            creationEntity.setCreatorId((String)Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null));
        }
        if (entity instanceof RecordModifierEntity) {
            creationEntity = (RecordModifierEntity)entity;
            creationEntity.setModifyTimeNow();
            creationEntity.setModifierId((String)Authentication.current().map(Authentication::getUser).map(User::getId).orElse(null));
        }
        return ResponseMessage.ok(((InsertService)((CreateEntityService)this.getService())).insert(entity));
    }

    @Authorize(ignore=true)
    public E modelToEntity(M var1, E var2);
}

