/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.api.crud.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.NestConditional;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class QueryParamEntity
extends QueryParam {
    private static final Logger log = LoggerFactory.getLogger(QueryParamEntity.class);
    private static final long serialVersionUID = 8097500947924037523L;
    private String where;
    private String orderBy;
    private Integer total;

    public static QueryParamEntity of() {
        return new QueryParamEntity();
    }

    public static QueryParamEntity of(String field, Object value) {
        return (QueryParamEntity)QueryParamEntity.of().and(field, "eq", value);
    }

    public static <T> Query<T, QueryParamEntity> newQuery() {
        return Query.of((QueryParam)new QueryParamEntity());
    }

    public <T> Query<T, QueryParamEntity> toQuery() {
        return Query.of((QueryParam)this);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery() {
        return this.toNestQuery(null);
    }

    public <T> Query<T, QueryParamEntity> toNestQuery(Consumer<Query<T, QueryParamEntity>> before) {
        List<Term> terms = this.getTerms();
        this.setTerms(new ArrayList());
        Query<T, QueryParamEntity> query = this.toQuery();
        if (null != before) {
            before.accept(query);
        }
        if (terms.isEmpty()) {
            return query;
        }
        return (Query)((NestConditional)query.nest().each(terms, NestConditional::accept)).end();
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        if (StringUtils.isEmpty((Object)this.where)) {
            return;
        }
        this.setSorts(TermExpressionParser.parseOrder(orderBy));
    }

    public void setWhere(String where) {
        this.where = where;
        if (StringUtils.isEmpty((Object)where)) {
            return;
        }
        this.setTerms(TermExpressionParser.parse(where));
    }

    public List<Term> getTerms() {
        List<Term> terms = super.getTerms();
        if (CollectionUtils.isEmpty((Collection)terms) && StringUtils.hasText((String)this.where)) {
            terms = TermExpressionParser.parse(this.where);
            this.setTerms(terms);
        }
        return terms;
    }

    public QueryParamEntity noPaging() {
        this.setPaging(false);
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }
}

