/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.ftp;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.hswebframework.web.ftp.FTPOperation;
import org.hswebframework.web.ftp.pool.FTPClientPool;
import org.jooq.lambda.Unchecked;

public class DefaultFTPOperation
implements FTPOperation {
    private FTPClientPool pool;

    protected FTPClient getClient() {
        return (FTPClient)this.pool.borrowObject();
    }

    protected void returnClient(FTPClient client) {
        this.pool.returnObject(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doExecute(Function<FTPClient, T> function) {
        FTPClient client = this.getClient();
        try {
            T t = function.apply(client);
            return t;
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean delete(String fileName) {
        return (Boolean)this.doExecute(Unchecked.function(client -> client.deleteFile(fileName)));
    }

    @Override
    public boolean rename(String from, String to) {
        return (Boolean)this.doExecute(Unchecked.function(client -> client.rename(from, to)));
    }

    @Override
    public boolean download(String fileName, OutputStream outputStream) {
        return (Boolean)this.doExecute(Unchecked.function(client -> client.retrieveFile(fileName, outputStream)));
    }

    @Override
    public boolean upload(String fileName, InputStream input) {
        return (Boolean)this.doExecute(Unchecked.function(client -> client.storeFile(fileName, input)));
    }

    @Override
    public boolean upload(String fileName, String text) {
        return (Boolean)this.doExecute(Unchecked.function(client -> {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes());){
                Boolean bl = client.storeFile(fileName, (InputStream)inputStream);
                return bl;
            }
        }));
    }

    @Override
    public void list(String path, Consumer<FTPFile> consumer) {
        this.doExecute(Unchecked.function(client -> {
            Arrays.stream(client.listFiles(path)).forEach(consumer);
            return null;
        }));
    }

    @ConstructorProperties(value={"pool"})
    public DefaultFTPOperation(FTPClientPool pool) {
        this.pool = pool;
    }
}

