/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.ftp.pool;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.hswebframework.web.ftp.pool.FTPClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPClientFactory
implements PooledObjectFactory<FTPClient> {
    private static Logger logger = LoggerFactory.getLogger(FTPClientFactory.class);
    private FTPClientProperties config;

    public FTPClientFactory(FTPClientProperties config) {
        this.config = config;
    }

    public PooledObject<FTPClient> makeObject() throws Exception {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(this.config.getClientTimeout());
        ftpClient.connect(this.config.getHost(), this.config.getPort());
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftpClient.disconnect();
            logger.warn("FTPServer refused connection");
            return null;
        }
        boolean result = ftpClient.login(this.config.getUsername(), this.config.getPassword());
        if (!result) {
            throw new ConnectException("ftp\u767b\u9646\u5931\u8d25:" + this.config.getUsername() + "/password:" + this.config.getPassword() + "@" + this.config.getHost());
        }
        ftpClient.setFileType(this.config.getTransferFileType());
        ftpClient.setBufferSize(1024);
        ftpClient.setControlEncoding(this.config.getEncoding());
        if (this.config.isPassiveMode()) {
            ftpClient.enterLocalPassiveMode();
        }
        return new DefaultPooledObject((Object)ftpClient);
    }

    public void destroyObject(PooledObject<FTPClient> p) throws Exception {
        try {
            ((FTPClient)p.getObject()).logout();
        }
        finally {
            ((FTPClient)p.getObject()).disconnect();
        }
    }

    public boolean validateObject(PooledObject<FTPClient> p) {
        try {
            ((FTPClient)p.getObject()).sendNoOp();
        }
        catch (IOException e) {
            logger.warn("validateObject ftp error!", (Throwable)e);
            return false;
        }
        return ((FTPClient)p.getObject()).isConnected() && ((FTPClient)p.getObject()).isAvailable();
    }

    public void activateObject(PooledObject<FTPClient> p) throws Exception {
        ((FTPClient)p.getObject()).sendNoOp();
    }

    public void passivateObject(PooledObject<FTPClient> p) {
    }
}

