/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.excel;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import org.hswebframework.web.excel.DefaultExcelImporter;

public interface ExcelImporter {
    public static final ExcelImporter instance = new DefaultExcelImporter();

    public <T> Result<T> doImport(InputStream var1, Class<T> var2, Function<T, Error> var3, Class ... var4);

    public static class Header {
        int sheetIndex;
        String header;
        String field;

        @ConstructorProperties(value={"sheetIndex", "header", "field"})
        Header(int sheetIndex, String header, String field) {
            this.sheetIndex = sheetIndex;
            this.header = header;
            this.field = field;
        }

        public static HeaderBuilder builder() {
            return new HeaderBuilder();
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public String getHeader() {
            return this.header;
        }

        public String getField() {
            return this.field;
        }

        public void setSheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public void setField(String field) {
            this.field = field;
        }

        public static class HeaderBuilder {
            private int sheetIndex;
            private String header;
            private String field;

            HeaderBuilder() {
            }

            public HeaderBuilder sheetIndex(int sheetIndex) {
                this.sheetIndex = sheetIndex;
                return this;
            }

            public HeaderBuilder header(String header) {
                this.header = header;
                return this;
            }

            public HeaderBuilder field(String field) {
                this.field = field;
                return this;
            }

            public Header build() {
                return new Header(this.sheetIndex, this.header, this.field);
            }

            public String toString() {
                return "ExcelImporter.Header.HeaderBuilder(sheetIndex=" + this.sheetIndex + ", header=" + this.header + ", field=" + this.field + ")";
            }
        }
    }

    public static class Error {
        int sheetIndex;
        int rowIndex;
        int errorType;
        Object reason;

        @ConstructorProperties(value={"sheetIndex", "rowIndex", "errorType", "reason"})
        Error(int sheetIndex, int rowIndex, int errorType, Object reason) {
            this.sheetIndex = sheetIndex;
            this.rowIndex = rowIndex;
            this.errorType = errorType;
            this.reason = reason;
        }

        public static ErrorBuilder builder() {
            return new ErrorBuilder();
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public Object getReason() {
            return this.reason;
        }

        public void setSheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public void setErrorType(int errorType) {
            this.errorType = errorType;
        }

        public void setReason(Object reason) {
            this.reason = reason;
        }

        public static class ErrorBuilder {
            private int sheetIndex;
            private int rowIndex;
            private int errorType;
            private Object reason;

            ErrorBuilder() {
            }

            public ErrorBuilder sheetIndex(int sheetIndex) {
                this.sheetIndex = sheetIndex;
                return this;
            }

            public ErrorBuilder rowIndex(int rowIndex) {
                this.rowIndex = rowIndex;
                return this;
            }

            public ErrorBuilder errorType(int errorType) {
                this.errorType = errorType;
                return this;
            }

            public ErrorBuilder reason(Object reason) {
                this.reason = reason;
                return this;
            }

            public Error build() {
                return new Error(this.sheetIndex, this.rowIndex, this.errorType, this.reason);
            }

            public String toString() {
                return "ExcelImporter.Error.ErrorBuilder(sheetIndex=" + this.sheetIndex + ", rowIndex=" + this.rowIndex + ", errorType=" + this.errorType + ", reason=" + this.reason + ")";
            }
        }
    }

    public static class Result<T> {
        int total;
        int success;
        int error;
        List<Header> headers;
        List<T> data;
        List<Error> errors;

        @ConstructorProperties(value={"total", "success", "error", "headers", "data", "errors"})
        Result(int total, int success, int error, List<Header> headers, List<T> data, List<Error> errors) {
            this.total = total;
            this.success = success;
            this.error = error;
            this.headers = headers;
            this.data = data;
            this.errors = errors;
        }

        public static <T> ResultBuilder<T> builder() {
            return new ResultBuilder();
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccess() {
            return this.success;
        }

        public int getError() {
            return this.error;
        }

        public List<Header> getHeaders() {
            return this.headers;
        }

        public List<T> getData() {
            return this.data;
        }

        public List<Error> getErrors() {
            return this.errors;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public void setSuccess(int success) {
            this.success = success;
        }

        public void setError(int error) {
            this.error = error;
        }

        public void setHeaders(List<Header> headers) {
            this.headers = headers;
        }

        public void setData(List<T> data) {
            this.data = data;
        }

        public void setErrors(List<Error> errors) {
            this.errors = errors;
        }

        public static class ResultBuilder<T> {
            private int total;
            private int success;
            private int error;
            private List<Header> headers;
            private List<T> data;
            private List<Error> errors;

            ResultBuilder() {
            }

            public ResultBuilder<T> total(int total) {
                this.total = total;
                return this;
            }

            public ResultBuilder<T> success(int success) {
                this.success = success;
                return this;
            }

            public ResultBuilder<T> error(int error) {
                this.error = error;
                return this;
            }

            public ResultBuilder<T> headers(List<Header> headers) {
                this.headers = headers;
                return this;
            }

            public ResultBuilder<T> data(List<T> data) {
                this.data = data;
                return this;
            }

            public ResultBuilder<T> errors(List<Error> errors) {
                this.errors = errors;
                return this;
            }

            public Result<T> build() {
                return new Result<T>(this.total, this.success, this.error, this.headers, this.data, this.errors);
            }

            public String toString() {
                return "ExcelImporter.Result.ResultBuilder(total=" + this.total + ", success=" + this.success + ", error=" + this.error + ", headers=" + this.headers + ", data=" + this.data + ", errors=" + this.errors + ")";
            }
        }
    }
}

