/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.excel;

import io.swagger.annotations.ApiModelProperty;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hswebframework.expands.office.excel.ExcelIO;
import org.hswebframework.web.ApplicationContextHolder;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.excel.Excel;
import org.hswebframework.web.excel.ExcelCellConverter;
import org.hswebframework.web.excel.ExcelImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultExcelImporter
implements ExcelImporter {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelImporter.class);
    protected static Map<Class, Map<Class, HeaderMapper>> headerMappings = new ConcurrentHashMap<Class, Map<Class, HeaderMapper>>();
    protected static ExcelCellConverter DEFAULT_CONVERTER = new ExcelCellConverter(){

        public Object convertFromCell(Object from) {
            return from;
        }

        public Object convertToCell(Object from) {
            if (from instanceof EnumDict) {
                return ((EnumDict)from).getText();
            }
            return from;
        }
    };
    protected ExcelCellConverter defaultConvert = DEFAULT_CONVERTER;

    protected Map<Class, HeaderMapper> createHeaderMapping(Class type) {
        if (type == String.class || Number.class.isAssignableFrom(type) || ClassUtils.isPrimitiveWrapper((Class)type) || type.isPrimitive() || type.isEnum() || type.isArray() || Date.class.isAssignableFrom(type)) {
            return new HashMap<Class, HeaderMapper>();
        }
        AtomicInteger index = new AtomicInteger(0);
        HashMap<Class, HeaderMapper> headerMapperMap = new HashMap<Class, HeaderMapper>();
        ReflectionUtils.doWithFields((Class)type, field -> {
            Excel excel = field.getAnnotation(Excel.class);
            ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
            if (excel == null && apiModelProperty == null || excel != null && excel.ignore()) {
                return;
            }
            String header = excel == null ? apiModelProperty.value() : excel.value();
            HeaderMapping mapping = new HeaderMapping();
            mapping.header = header;
            mapping.field = field.getName();
            mapping.index = excel == null || excel.exportOrder() == -1 ? index.getAndAdd(1) : excel.exportOrder();
            if (null != excel) {
                mapping.enableImport = excel.enableImport();
                mapping.enableExport = excel.enableExport();
                mapping.children = () -> this.getHeaderMapper(field.getType(), excel.group());
                for (Class group : excel.group()) {
                    headerMapperMap.computeIfAbsent(group, x$0 -> new DefaultHeaderMapper((Class)x$0)).mappings.add(mapping);
                }
                mapping.converter = this.createConvert(excel.converter(), field.getType());
            } else {
                mapping.converter = this.createConvert(ExcelCellConverter.class, field.getType());
                mapping.children = () -> this.getHeaderMapper(field.getType(), new Class[0]);
                headerMapperMap.computeIfAbsent(Void.class, x$0 -> new DefaultHeaderMapper((Class)x$0)).mappings.add(mapping);
            }
        });
        return headerMapperMap;
    }

    protected <T> ExcelCellConverter<T> createConvert(Class<? extends ExcelCellConverter> converterClass, Class<T> type) {
        if (converterClass != ExcelCellConverter.class) {
            try {
                return (ExcelCellConverter)ApplicationContextHolder.get().getBean(converterClass);
            }
            catch (Exception e) {
                log.warn("can not get bean ({}) from spring context.", converterClass, (Object)e);
                return converterClass.newInstance();
            }
        }
        return this.defaultConvert;
    }

    protected HeaderMapper getHeaderMapper(Class type, Class ... group) {
        Map mapperMap = headerMappings.computeIfAbsent(type, this::createHeaderMapping);
        if (group != null && group.length > 0) {
            return Arrays.stream(group).map(mapperMap::get).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return (HeaderMapper)mapperMap.get(Void.class);
    }

    @Override
    public <T> ExcelImporter.Result<T> doImport(InputStream inputStream, Class<T> type, Function<T, ExcelImporter.Error> afterParsed, Class ... group) {
        AtomicInteger counter = new AtomicInteger(0);
        AtomicInteger errorCounter = new AtomicInteger(0);
        ArrayList data = new ArrayList();
        ArrayList<ExcelImporter.Error> errors = new ArrayList<ExcelImporter.Error>();
        HeaderMapper headerMapper = this.getHeaderMapper(type, group);
        if (headerMapper == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5bfc\u5165\u6b64\u7c7b\u578b");
        }
        ExcelIO.read((InputStream)inputStream, row -> {
            counter.getAndAdd(1);
            Map mapValue = (Map)row.getResult();
            HashMap newValue = new HashMap();
            for (Map.Entry entry : mapValue.entrySet()) {
                String key = (String)entry.getKey();
                HeaderMapping mapping = headerMapper.getMapping(key).orElse(null);
                if (mapping == null || !mapping.enableImport) continue;
                Object value = mapping.getConverter().convertFromCell(entry.getValue());
                String field = mapping.getField();
                if (field.contains(".")) {
                    String tmpField = field;
                    Map nestMapValue = newValue;
                    while (tmpField.contains(".")) {
                        String[] nestFields = tmpField.split("[.]", 2);
                        String nestField = nestFields[0];
                        tmpField = nestFields[1];
                        Object nestValue = nestMapValue.get(nestField);
                        if (nestValue == null) {
                            HashMap hashMap = nestMapValue;
                            nestMapValue = new HashMap();
                            hashMap.put(nestField, nestMapValue);
                            continue;
                        }
                        if (nestValue instanceof Map) {
                            nestMapValue = (Map)nestValue;
                            continue;
                        }
                        HashMap hashMap = nestMapValue;
                        nestMapValue = (Map)FastBeanCopier.copy(nestValue, new HashMap(), (String[])new String[0]);
                        hashMap.put(nestField, nestMapValue);
                    }
                    nestMapValue.put(tmpField, value);
                    continue;
                }
                newValue.put(field, value);
            }
            Object instance = FastBeanCopier.getBeanFactory().newInstance(type);
            FastBeanCopier.copy(newValue, (Object)instance, (String[])new String[0]);
            data.add(instance);
            ExcelImporter.Error error = (ExcelImporter.Error)afterParsed.apply(instance);
            if (null != error) {
                errorCounter.getAndAdd(1);
                error.setRowIndex(counter.get());
                error.setSheetIndex(row.getSheet());
                errors.add(error);
            }
        });
        return ExcelImporter.Result.builder().data(data).errors(errors).success(counter.get() - errorCounter.get()).total(counter.get()).error(errorCounter.get()).build();
    }

    static interface HeaderMapper {
        public Optional<HeaderMapping> getMapping(String var1);
    }

    class DefaultHeaderMapper
    implements HeaderMapper {
        private Class group;
        private Map<String, HeaderMapping> fastMapping = new HashMap<String, HeaderMapping>();
        private final List<HeaderMapping> mappings = new ArrayList<HeaderMapping>(){
            private static final long serialVersionUID = 5995980497414973311L;

            @Override
            public boolean add(HeaderMapping o) {
                DefaultHeaderMapper.this.fastMapping.put(o.header, o);
                DefaultHeaderMapper.this.fastMapping.put(o.field, o);
                return super.add(o);
            }
        };

        public DefaultHeaderMapper(Class group) {
            this.group = group;
        }

        @Override
        public Optional<HeaderMapping> getMapping(String key) {
            return Optional.ofNullable(this.fastMapping.computeIfAbsent(key, k -> {
                Iterator<HeaderMapping> iterator = this.mappings.iterator();
                while (iterator.hasNext()) {
                    HeaderMapping map;
                    HeaderMapper mapper;
                    String newKey = key;
                    HeaderMapping mapping = iterator.next();
                    if (newKey.startsWith(mapping.field)) {
                        newKey = newKey.substring(mapping.field.length());
                    } else {
                        if (!newKey.startsWith(mapping.header)) continue;
                        newKey = newKey.substring(mapping.header.length());
                    }
                    if (null == (mapper = (HeaderMapper)mapping.children.get()) || (map = (HeaderMapping)mapper.getMapping(newKey).orElse(null)) == null) continue;
                    map = map.copy();
                    map.field = mapping.field.concat(".").concat(map.field);
                    map.header = mapping.header.concat(map.header);
                    return map;
                }
                return null;
            }));
        }

        public Class getGroup() {
            return this.group;
        }
    }

    class HeaderMapping
    implements Comparable<HeaderMapping> {
        private String field;
        private String header;
        private int index;
        private boolean enableExport = true;
        private boolean enableImport = true;
        private Supplier<HeaderMapper> children;
        private ExcelCellConverter converter;

        HeaderMapping() {
        }

        public HeaderMapping copy() {
            HeaderMapping mapping = new HeaderMapping();
            mapping.children = this.children;
            mapping.field = this.field;
            mapping.header = this.header;
            mapping.index = this.index;
            mapping.enableImport = this.enableImport;
            mapping.enableExport = this.enableExport;
            mapping.children = this.children;
            mapping.converter = this.converter;
            return mapping;
        }

        @Override
        public int compareTo(HeaderMapping o) {
            return Integer.compare(this.index, o.index);
        }

        public String getField() {
            return this.field;
        }

        public String getHeader() {
            return this.header;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isEnableExport() {
            return this.enableExport;
        }

        public boolean isEnableImport() {
            return this.enableImport;
        }

        public Supplier<HeaderMapper> getChildren() {
            return this.children;
        }

        public ExcelCellConverter getConverter() {
            return this.converter;
        }
    }
}

