/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.oauth2.ErrorType;
import org.hswebframework.web.oauth2.OAuth2Exception;
import org.hswebframework.web.oauth2.server.AccessToken;
import org.hswebframework.web.oauth2.server.OAuth2Client;
import org.hswebframework.web.oauth2.server.OAuth2ClientManager;
import org.hswebframework.web.oauth2.server.OAuth2GrantService;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeRequest;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeTokenRequest;
import org.hswebframework.web.oauth2.server.credential.ClientCredentialRequest;
import org.hswebframework.web.oauth2.server.refresh.RefreshTokenRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@RestController
@RequestMapping(value={"/oauth2"})
@Tag(name="OAuth2\u8ba4\u8bc1")
public class OAuth2AuthorizeController {
    private final OAuth2GrantService oAuth2GrantService;
    private final OAuth2ClientManager clientManager;

    @GetMapping(value={"/authorize"}, params={"response_type=code"})
    @Operation(summary="\u7533\u8bf7\u6388\u6743\u7801,\u5e76\u83b7\u53d6\u91cd\u5b9a\u5411\u5730\u5740", parameters={@Parameter(name="client_id", required=true), @Parameter(name="redirect_uri", required=true), @Parameter(name="state"), @Parameter(name="response_type", description="\u56fa\u5b9a\u503c\u4e3acode")})
    public Mono<String> authorizeByCode(ServerWebExchange exchange) {
        HashMap param = new HashMap(exchange.getRequest().getQueryParams().toSingleValueMap());
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> this.getOAuth2Client((String)param.get("client_id")).flatMap(client -> {
            String redirectUri = param.getOrDefault("redirect_uri", client.getRedirectUrl());
            client.validateRedirectUri(redirectUri);
            return this.oAuth2GrantService.authorizationCode().requestCode(new AuthorizationCodeRequest((OAuth2Client)client, (Authentication)auth, param)).doOnNext(response -> Optional.ofNullable(param.get("state")).ifPresent(state -> response.with("state", state))).map(response -> OAuth2AuthorizeController.buildRedirect(redirectUri, response.getParameters()));
        }));
    }

    @GetMapping(value={"/token"})
    @Operation(summary="(GET)\u7533\u8bf7token", parameters={@Parameter(name="client_id"), @Parameter(name="client_secret"), @Parameter(name="code", description="grantType\u4e3aauthorization_code\u65f6\u4e0d\u80fd\u4e3a\u7a7a"), @Parameter(name="grant_type", schema=@Schema(implementation=GrantType.class))})
    @Authorize(ignore=true)
    public Mono<ResponseEntity<AccessToken>> requestTokenByCode(@RequestParam(value="grant_type") GrantType grantType, ServerWebExchange exchange) {
        Map params = exchange.getRequest().getQueryParams().toSingleValueMap();
        Tuple2<String, String> clientIdAndSecret = this.getClientIdAndClientSecret(params, exchange);
        return this.getOAuth2Client((String)clientIdAndSecret.getT1()).doOnNext(client -> client.validateSecret((String)clientIdAndSecret.getT2())).flatMap(client -> grantType.requestToken(this.oAuth2GrantService, (OAuth2Client)client, (Map<String, String>)new HashMap<String, String>(params))).map(ResponseEntity::ok);
    }

    @PostMapping(value={"/token"}, consumes={"application/x-www-form-urlencoded"})
    @Operation(summary="(POST)\u7533\u8bf7token", parameters={@Parameter(name="client_id"), @Parameter(name="client_secret"), @Parameter(name="code", description="grantType\u4e3aauthorization_code\u65f6\u4e0d\u80fd\u4e3a\u7a7a"), @Parameter(name="grant_type", schema=@Schema(implementation=GrantType.class))})
    @Authorize(ignore=true)
    public Mono<ResponseEntity<AccessToken>> requestTokenByCode(ServerWebExchange exchange) {
        return exchange.getFormData().map(MultiValueMap::toSingleValueMap).flatMap(params -> {
            Tuple2<String, String> clientIdAndSecret = this.getClientIdAndClientSecret((Map<String, String>)params, exchange);
            GrantType grantType = GrantType.of((String)params.get("grant_type"));
            return this.getOAuth2Client((String)clientIdAndSecret.getT1()).doOnNext(client -> client.validateSecret((String)clientIdAndSecret.getT2())).flatMap(client -> grantType.requestToken(this.oAuth2GrantService, (OAuth2Client)client, (Map<String, String>)new HashMap<String, String>((Map<String, String>)params))).map(ResponseEntity::ok);
        });
    }

    private Tuple2<String, String> getClientIdAndClientSecret(Map<String, String> params, ServerWebExchange exchange) {
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        if (authorization != null && authorization.startsWith("Basic ")) {
            String[] arr = new String(Base64.decodeBase64((String)authorization.substring(5))).split(":");
            if (arr.length >= 2) {
                return Tuples.of((Object)arr[0], (Object)arr[1]);
            }
            return Tuples.of((Object)arr[0], (Object)arr[0]);
        }
        return Tuples.of((Object)params.getOrDefault("client_id", ""), (Object)params.getOrDefault("client_secret", ""));
    }

    public static String urlEncode(String url) {
        return URLEncoder.encode(url, "utf-8");
    }

    static String buildRedirect(String redirectUri, Map<String, Object> params) {
        String paramsString = params.entrySet().stream().map(e -> (String)e.getKey() + "=" + OAuth2AuthorizeController.urlEncode(String.valueOf(e.getValue()))).collect(Collectors.joining("&"));
        if (redirectUri.contains("?")) {
            return redirectUri + "&" + paramsString;
        }
        return redirectUri + "?" + paramsString;
    }

    private Mono<OAuth2Client> getOAuth2Client(String id) {
        return this.clientManager.getClient(id).switchIfEmpty(Mono.error(() -> new OAuth2Exception(ErrorType.ILLEGAL_CLIENT_ID)));
    }

    public OAuth2AuthorizeController(OAuth2GrantService oAuth2GrantService, OAuth2ClientManager clientManager) {
        this.oAuth2GrantService = oAuth2GrantService;
        this.clientManager = clientManager;
    }

    public static enum GrantType {
        authorization_code{

            @Override
            Mono<AccessToken> requestToken(OAuth2GrantService service, OAuth2Client client, Map<String, String> param) {
                return service.authorizationCode().requestToken(new AuthorizationCodeTokenRequest(client, param));
            }
        }
        ,
        client_credentials{

            @Override
            Mono<AccessToken> requestToken(OAuth2GrantService service, OAuth2Client client, Map<String, String> param) {
                return service.clientCredential().requestToken(new ClientCredentialRequest(client, param));
            }
        }
        ,
        refresh_token{

            @Override
            Mono<AccessToken> requestToken(OAuth2GrantService service, OAuth2Client client, Map<String, String> param) {
                return service.refreshToken().requestToken(new RefreshTokenRequest(client, param));
            }
        };


        abstract Mono<AccessToken> requestToken(OAuth2GrantService var1, OAuth2Client var2, Map<String, String> var3);

        static GrantType of(String name) {
            try {
                return GrantType.valueOf(name);
            }
            catch (Throwable e) {
                throw new OAuth2Exception(ErrorType.UNSUPPORTED_GRANT_TYPE);
            }
        }
    }
}

