/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.impl;

import java.time.Duration;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.oauth2.ErrorType;
import org.hswebframework.web.oauth2.OAuth2Exception;
import org.hswebframework.web.oauth2.server.AccessToken;
import org.hswebframework.web.oauth2.server.AccessTokenManager;
import org.hswebframework.web.oauth2.server.impl.RedisAccessToken;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Mono;

public class RedisAccessTokenManager
implements AccessTokenManager {
    private final ReactiveRedisOperations<String, RedisAccessToken> tokenRedis;
    private int tokenExpireIn = 7200;
    private int refreshExpireIn = 2592000;

    public RedisAccessTokenManager(ReactiveRedisOperations<String, RedisAccessToken> tokenRedis) {
        this.tokenRedis = tokenRedis;
    }

    public RedisAccessTokenManager(ReactiveRedisConnectionFactory connectionFactory) {
        this((ReactiveRedisOperations<String, RedisAccessToken>)new ReactiveRedisTemplate(connectionFactory, RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(RedisSerializer.java()).hashKey(RedisSerializer.string()).hashValue(RedisSerializer.java()).build()));
    }

    @Override
    public Mono<Authentication> getAuthenticationByToken(String accessToken) {
        return this.tokenRedis.opsForValue().get((Object)this.createTokenRedisKey(accessToken)).map(RedisAccessToken::getAuthentication);
    }

    private String createTokenRedisKey(String token) {
        return "oauth2-token:" + token;
    }

    private String createRefreshTokenRedisKey(String token) {
        return "oauth2-refresh-token:" + token;
    }

    private String createSingletonTokenRedisKey(String clientId) {
        return "oauth2-" + clientId + "-token";
    }

    private Mono<RedisAccessToken> doCreateAccessToken(String clientId, Authentication authentication, boolean singleton) {
        String token = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
        String refresh = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
        RedisAccessToken accessToken = new RedisAccessToken(clientId, token, refresh, System.currentTimeMillis(), authentication, singleton);
        return this.storeToken(accessToken).thenReturn((Object)accessToken);
    }

    private Mono<Void> storeToken(RedisAccessToken token) {
        return Mono.zip((Mono)this.tokenRedis.opsForValue().set((Object)this.createTokenRedisKey(token.getAccessToken()), (Object)token, Duration.ofSeconds(this.tokenExpireIn)), (Mono)this.tokenRedis.opsForValue().set((Object)this.createRefreshTokenRedisKey(token.getRefreshToken()), (Object)token, Duration.ofSeconds(this.refreshExpireIn))).then();
    }

    private Mono<AccessToken> doCreateSingletonAccessToken(String clientId, Authentication authentication) {
        String redisKey = this.createSingletonTokenRedisKey(clientId);
        return this.tokenRedis.opsForValue().get((Object)redisKey).flatMap(token -> this.tokenRedis.getExpire((Object)redisKey).map(duration -> token.toAccessToken((int)(duration.toMillis() / 1000L)))).switchIfEmpty(Mono.defer(() -> this.doCreateAccessToken(clientId, authentication, true).flatMap(redisAccessToken -> this.tokenRedis.opsForValue().set((Object)redisKey, redisAccessToken, Duration.ofSeconds(this.tokenExpireIn)).thenReturn((Object)redisAccessToken.toAccessToken(this.tokenExpireIn)))));
    }

    @Override
    public Mono<AccessToken> createAccessToken(String clientId, Authentication authentication, boolean singleton) {
        return singleton ? this.doCreateSingletonAccessToken(clientId, authentication) : this.doCreateAccessToken(clientId, authentication, false).map(token -> token.toAccessToken(this.tokenExpireIn));
    }

    @Override
    public Mono<AccessToken> refreshAccessToken(String clientId, String refreshToken) {
        String redisKey = this.createRefreshTokenRedisKey(refreshToken);
        return this.tokenRedis.opsForValue().get((Object)redisKey).switchIfEmpty(Mono.error(() -> new OAuth2Exception(ErrorType.EXPIRED_REFRESH_TOKEN))).flatMap(token -> {
            if (!token.getClientId().equals(clientId)) {
                return Mono.error((Throwable)((Object)new OAuth2Exception(ErrorType.ILLEGAL_CLIENT_ID)));
            }
            String accessToken = DigestUtils.md5Hex((String)UUID.randomUUID().toString());
            token.setAccessToken(accessToken);
            token.setCreateTime(System.currentTimeMillis());
            return ((Mono)this.storeToken((RedisAccessToken)token).as(result -> {
                if (token.isSingleton()) {
                    return this.tokenRedis.opsForValue().set((Object)this.createSingletonTokenRedisKey(clientId), token, Duration.ofSeconds(this.tokenExpireIn)).then(result);
                }
                return result;
            })).thenReturn((Object)token.toAccessToken(this.tokenExpireIn));
        });
    }

    public int getTokenExpireIn() {
        return this.tokenExpireIn;
    }

    public void setTokenExpireIn(int tokenExpireIn) {
        this.tokenExpireIn = tokenExpireIn;
    }

    public int getRefreshExpireIn() {
        return this.refreshExpireIn;
    }

    public void setRefreshExpireIn(int refreshExpireIn) {
        this.refreshExpireIn = refreshExpireIn;
    }
}

