/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server.code;

import java.time.Duration;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.oauth2.ErrorType;
import org.hswebframework.web.oauth2.OAuth2Exception;
import org.hswebframework.web.oauth2.server.AccessToken;
import org.hswebframework.web.oauth2.server.AccessTokenManager;
import org.hswebframework.web.oauth2.server.OAuth2Client;
import org.hswebframework.web.oauth2.server.ScopePredicate;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeCache;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeGranter;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeRequest;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeResponse;
import org.hswebframework.web.oauth2.server.code.AuthorizationCodeTokenRequest;
import org.hswebframework.web.oauth2.server.utils.OAuth2ScopeUtils;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveValueOperations;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import reactor.core.publisher.Mono;

public class DefaultAuthorizationCodeGranter
implements AuthorizationCodeGranter {
    private final AccessTokenManager accessTokenManager;
    private final ReactiveRedisOperations<String, AuthorizationCodeCache> redis;

    public DefaultAuthorizationCodeGranter(AccessTokenManager accessTokenManager, ReactiveRedisConnectionFactory connectionFactory) {
        this(accessTokenManager, (ReactiveRedisOperations<String, AuthorizationCodeCache>)new ReactiveRedisTemplate(connectionFactory, RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(RedisSerializer.java()).hashKey(RedisSerializer.string()).hashValue(RedisSerializer.java()).build()));
    }

    @Override
    public Mono<AuthorizationCodeResponse> requestCode(AuthorizationCodeRequest request) {
        OAuth2Client client = request.getClient();
        Authentication authentication = request.getAuthentication();
        AuthorizationCodeCache codeCache = new AuthorizationCodeCache();
        String code = (String)IDGenerator.MD5.generate();
        request.getParameter("scope").map(String::valueOf).ifPresent(codeCache::setScope);
        codeCache.setCode(code);
        codeCache.setClientId(client.getClientId());
        ScopePredicate permissionPredicate = OAuth2ScopeUtils.createScopePredicate(codeCache.getScope());
        codeCache.setAuthentication(authentication.copy((permission, action) -> permissionPredicate.test(permission.getId(), (String)action), dimension -> true));
        return this.redis.opsForValue().set((Object)this.getRedisKey(code), (Object)codeCache, Duration.ofMinutes(5L)).thenReturn((Object)new AuthorizationCodeResponse(code));
    }

    private String getRedisKey(String code) {
        return "oauth2-code:" + code;
    }

    @Override
    public Mono<AccessToken> requestToken(AuthorizationCodeTokenRequest request) {
        return Mono.justOrEmpty(request.code()).map(this::getRedisKey).flatMap(arg_0 -> ((ReactiveValueOperations)this.redis.opsForValue()).get(arg_0)).switchIfEmpty(Mono.error(() -> new OAuth2Exception(ErrorType.ILLEGAL_CODE))).flatMap(cache -> this.redis.opsForValue().delete((Object)this.getRedisKey(cache.getCode())).thenReturn(cache)).flatMap(cache -> {
            if (!request.getClient().getClientId().equals(cache.getClientId())) {
                return Mono.error((Throwable)((Object)new OAuth2Exception(ErrorType.ILLEGAL_CLIENT_ID)));
            }
            return this.accessTokenManager.createAccessToken(cache.getClientId(), cache.getAuthentication(), false);
        });
    }

    public DefaultAuthorizationCodeGranter(AccessTokenManager accessTokenManager, ReactiveRedisOperations<String, AuthorizationCodeCache> redis) {
        this.accessTokenManager = accessTokenManager;
        this.redis = redis;
    }
}

