/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.oauth2.server;

import javax.validation.constraints.NotBlank;
import org.hswebframework.web.oauth2.ErrorType;
import org.hswebframework.web.oauth2.OAuth2Exception;
import org.springframework.util.StringUtils;

public class OAuth2Client {
    @NotBlank
    private String clientId;
    @NotBlank
    private String clientSecret;
    @NotBlank
    private String name;
    private String description;
    @NotBlank
    private String redirectUrl;
    private String userId;

    public void validateRedirectUri(String redirectUri) {
        if (StringUtils.isEmpty((Object)redirectUri) || !redirectUri.startsWith(this.redirectUrl)) {
            throw new OAuth2Exception(ErrorType.ILLEGAL_REDIRECT_URI);
        }
    }

    public void validateSecret(String secret) {
        if (StringUtils.isEmpty((Object)secret) || !secret.equals(this.clientSecret)) {
            throw new OAuth2Exception(ErrorType.ILLEGAL_CLIENT_SECRET);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

