/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.oauth2.client.AccessTokenInfo;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestBuilderFactory;
import org.hswebframework.web.authorization.oauth2.client.OAuth2ServerConfig;
import org.hswebframework.web.authorization.oauth2.client.OAuth2SessionBuilder;
import org.hswebframework.web.authorization.oauth2.client.request.OAuth2Session;
import org.hswebframework.web.authorization.oauth2.client.simple.OAuth2UserTokenRepository;
import org.hswebframework.web.authorization.oauth2.client.simple.session.AuthorizationCodeSession;
import org.hswebframework.web.authorization.oauth2.client.simple.session.CachedOAuth2Session;
import org.hswebframework.web.authorization.oauth2.client.simple.session.DefaultOAuth2Session;
import org.hswebframework.web.authorization.oauth2.client.simple.session.PasswordSession;

public class SimpleOAuth2SessionBuilder
implements OAuth2SessionBuilder {
    private OAuth2UserTokenRepository oAuth2UserTokenRepository;
    private OAuth2ServerConfig serverConfig;
    private OAuth2RequestBuilderFactory requestBuilderFactory;
    private ReadWriteLock readWriteLock;
    private final Consumer<AccessTokenInfo> onClientCredentialsTokenChanged = this.createOnTokenChanged(this::getClientCredentialsToken, "client_credentials");
    private Supplier<AccessTokenInfo> tokenGetter = () -> {
        this.readWriteLock.readLock().lock();
        try {
            AccessTokenInfo accessTokenInfo = this.getClientCredentialsToken();
            return accessTokenInfo;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    };

    public SimpleOAuth2SessionBuilder(OAuth2UserTokenRepository oAuth2UserTokenRepository, OAuth2ServerConfig oAuth2ServerConfig, OAuth2RequestBuilderFactory requestBuilderFactory, ReadWriteLock readWriteLock) {
        this.oAuth2UserTokenRepository = oAuth2UserTokenRepository;
        this.serverConfig = oAuth2ServerConfig;
        this.requestBuilderFactory = requestBuilderFactory;
        this.readWriteLock = readWriteLock;
    }

    protected String getRealUrl(String url) {
        if (url.startsWith("http")) {
            return url;
        }
        if (!this.serverConfig.getApiBaseUrl().endsWith("/") && !url.startsWith("/")) {
            return this.serverConfig.getApiBaseUrl().concat("/").concat(url);
        }
        return this.serverConfig.getApiBaseUrl() + url;
    }

    protected AccessTokenInfo getClientCredentialsToken() {
        return this.oAuth2UserTokenRepository.findByServerIdAndGrantType(this.serverConfig.getId(), "client_credentials").stream().findAny().orElse(null);
    }

    protected Consumer<AccessTokenInfo> createOnTokenChanged(Supplier<AccessTokenInfo> tokenGetter, String grantType) {
        return token -> {
            this.readWriteLock.writeLock().lock();
            AccessTokenInfo tokenInfo = (AccessTokenInfo)tokenGetter.get();
            try {
                token.setGrantType(grantType);
                token.setServerId(this.serverConfig.getId());
                if (tokenInfo != null) {
                    token.setId(tokenInfo.getId());
                    token.setUpdateTime(System.currentTimeMillis());
                    this.oAuth2UserTokenRepository.update(tokenInfo.getId(), (AccessTokenInfo)token);
                } else {
                    token.setCreateTime(System.currentTimeMillis());
                    token.setUpdateTime(System.currentTimeMillis());
                    this.oAuth2UserTokenRepository.insert((AccessTokenInfo)token);
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        };
    }

    @Override
    public OAuth2Session byAuthorizationCode(String code) {
        AuthorizationCodeSession authorizationCodeSession = new AuthorizationCodeSession();
        authorizationCodeSession.setCode(code);
        authorizationCodeSession.setRequestBuilderFactory(this.requestBuilderFactory);
        authorizationCodeSession.setServerConfig(this.serverConfig);
        authorizationCodeSession.init();
        return authorizationCodeSession;
    }

    @Override
    public OAuth2Session byClientCredentials() {
        DefaultOAuth2Session session;
        AccessTokenInfo info = this.tokenGetter.get();
        if (null != info) {
            session = new CachedOAuth2Session(info);
        } else {
            this.readWriteLock.writeLock().lock();
            try {
                info = this.getClientCredentialsToken();
                if (null == info) {
                    session = new DefaultOAuth2Session();
                    session.setServerConfig(this.serverConfig);
                    session.setRequestBuilderFactory(this.requestBuilderFactory);
                    session.onTokenChanged(this.onClientCredentialsTokenChanged);
                    session.init();
                    session.param("grant_type", "client_credentials");
                    info = session.requestAccessToken();
                    info.setGrantType("client_credentials");
                    info.setCreateTime(System.currentTimeMillis());
                    info.setServerId(this.serverConfig.getId());
                    this.oAuth2UserTokenRepository.insert(info);
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
            session = new CachedOAuth2Session(info);
        }
        session.setServerConfig(this.serverConfig);
        session.setRequestBuilderFactory(this.requestBuilderFactory);
        session.onTokenChanged(this.onClientCredentialsTokenChanged);
        session.init();
        session.param("grant_type", "client_credentials");
        return session;
    }

    @Override
    public OAuth2Session byPassword(String username, String password) {
        PasswordSession session = new PasswordSession(username, password);
        session.setServerConfig(this.serverConfig);
        session.setRequestBuilderFactory(this.requestBuilderFactory);
        session.init();
        return session;
    }

    @Override
    public OAuth2Session byAccessToken(String accessToken) {
        Supplier<AccessTokenInfo> supplier = () -> this.oAuth2UserTokenRepository.findByAccessToken(accessToken);
        AccessTokenInfo tokenInfo = supplier.get();
        if (tokenInfo == null) {
            throw new NotFoundException("access_token not found");
        }
        CachedOAuth2Session session = new CachedOAuth2Session(tokenInfo);
        session.setServerConfig(this.serverConfig);
        session.setRequestBuilderFactory(this.requestBuilderFactory);
        session.onTokenChanged(this.createOnTokenChanged(supplier, null));
        session.init();
        return session;
    }
}

