/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.utils.ClassUtils;
import org.hswebframework.web.NotFoundException;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestBuilderFactory;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestService;
import org.hswebframework.web.authorization.oauth2.client.OAuth2ServerConfig;
import org.hswebframework.web.authorization.oauth2.client.OAuth2SessionBuilder;
import org.hswebframework.web.authorization.oauth2.client.listener.OAuth2Event;
import org.hswebframework.web.authorization.oauth2.client.listener.OAuth2Listener;
import org.hswebframework.web.authorization.oauth2.client.simple.OAuth2ServerConfigRepository;
import org.hswebframework.web.authorization.oauth2.client.simple.OAuth2UserTokenRepository;
import org.hswebframework.web.authorization.oauth2.client.simple.SimpleOAuth2SessionBuilder;
import org.hswebframework.web.commons.entity.DataStatus;
import org.hswebframework.web.concurrent.lock.LockManager;

public class SimpleOAuth2RequestService
implements OAuth2RequestService {
    private OAuth2ServerConfigRepository oAuth2ServerConfigService;
    private OAuth2UserTokenRepository oAuth2UserTokenService;
    private OAuth2RequestBuilderFactory oAuth2RequestBuilderFactory;
    private Map<String, Map<Class, List<OAuth2Listener>>> listenerStore = new HashMap<String, Map<Class, List<OAuth2Listener>>>();
    private LockManager lockManager;

    public SimpleOAuth2RequestService(OAuth2ServerConfigRepository oAuth2ServerConfigService, OAuth2UserTokenRepository oAuth2UserTokenService, OAuth2RequestBuilderFactory oAuth2RequestBuilderFactory, LockManager lockManager) {
        this.oAuth2ServerConfigService = oAuth2ServerConfigService;
        this.oAuth2UserTokenService = oAuth2UserTokenService;
        this.oAuth2RequestBuilderFactory = oAuth2RequestBuilderFactory;
        this.lockManager = lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    @Override
    public OAuth2SessionBuilder create(String serverId) {
        OAuth2ServerConfig configEntity = this.oAuth2ServerConfigService.findById(serverId);
        if (null == configEntity || !DataStatus.STATUS_ENABLED.equals(configEntity.getStatus())) {
            throw new NotFoundException("server not found!");
        }
        return new SimpleOAuth2SessionBuilder(this.oAuth2UserTokenService, configEntity, this.oAuth2RequestBuilderFactory, this.lockManager.getReadWriteLock("oauth2-server-lock." + serverId));
    }

    @Override
    public void registerListener(String serverId, OAuth2Listener<? extends OAuth2Event> listener) {
        Class type = ClassUtils.getGenericType(listener.getClass());
        this.listenerStore.computeIfAbsent(serverId, k -> new HashMap()).computeIfAbsent(type, k -> new ArrayList()).add(listener);
    }

    @Override
    public void doEvent(String serverId, OAuth2Event event) {
        this.doEvent(serverId, event, event.getClass());
    }

    @Override
    public void doEvent(String serverId, OAuth2Event event, Class<? extends OAuth2Event> eventType) {
        ((List)((Map)this.listenerStore.getOrDefault(serverId, new HashMap())).getOrDefault(eventType, new ArrayList())).forEach(listener -> listener.on(event));
    }
}

