/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class OAuth2ServerConfig
implements Serializable {
    private static final long serialVersionUID = 2915370625863707033L;
    private String id;
    private String name;
    private String apiBaseUrl;
    private String authUrl;
    private String accessTokenUrl;
    private String clientId;
    private String clientSecret;
    private Byte status;
    private String redirectUri;
    private String provider;

    public static OAuth2ServerConfigBuilder builder() {
        return new OAuth2ServerConfigBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApiBaseUrl(String apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public OAuth2ServerConfig() {
    }

    @ConstructorProperties(value={"id", "name", "apiBaseUrl", "authUrl", "accessTokenUrl", "clientId", "clientSecret", "status", "redirectUri", "provider"})
    public OAuth2ServerConfig(String id, String name, String apiBaseUrl, String authUrl, String accessTokenUrl, String clientId, String clientSecret, Byte status, String redirectUri, String provider) {
        this.id = id;
        this.name = name;
        this.apiBaseUrl = apiBaseUrl;
        this.authUrl = authUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.status = status;
        this.redirectUri = redirectUri;
        this.provider = provider;
    }

    public static class OAuth2ServerConfigBuilder {
        private String id;
        private String name;
        private String apiBaseUrl;
        private String authUrl;
        private String accessTokenUrl;
        private String clientId;
        private String clientSecret;
        private Byte status;
        private String redirectUri;
        private String provider;

        OAuth2ServerConfigBuilder() {
        }

        public OAuth2ServerConfigBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OAuth2ServerConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OAuth2ServerConfigBuilder apiBaseUrl(String apiBaseUrl) {
            this.apiBaseUrl = apiBaseUrl;
            return this;
        }

        public OAuth2ServerConfigBuilder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public OAuth2ServerConfigBuilder accessTokenUrl(String accessTokenUrl) {
            this.accessTokenUrl = accessTokenUrl;
            return this;
        }

        public OAuth2ServerConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuth2ServerConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuth2ServerConfigBuilder status(Byte status) {
            this.status = status;
            return this;
        }

        public OAuth2ServerConfigBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public OAuth2ServerConfigBuilder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public OAuth2ServerConfig build() {
            return new OAuth2ServerConfig(this.id, this.name, this.apiBaseUrl, this.authUrl, this.accessTokenUrl, this.clientId, this.clientSecret, this.status, this.redirectUri, this.provider);
        }

        public String toString() {
            return "OAuth2ServerConfig.OAuth2ServerConfigBuilder(id=" + this.id + ", name=" + this.name + ", apiBaseUrl=" + this.apiBaseUrl + ", authUrl=" + this.authUrl + ", accessTokenUrl=" + this.accessTokenUrl + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", status=" + this.status + ", redirectUri=" + this.redirectUri + ", provider=" + this.provider + ")";
        }
    }
}

