/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.oauth2.client.simple.request.builder;

import java.util.HashMap;
import java.util.Map;
import org.hswebframework.expands.request.RequestBuilder;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestBuilder;
import org.hswebframework.web.authorization.oauth2.client.OAuth2RequestBuilderFactory;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseConvertHandler;
import org.hswebframework.web.authorization.oauth2.client.request.ResponseJudge;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseConvertForProviderDefinition;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseConvertForServerIdDefinition;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseJudgeForProviderDefinition;
import org.hswebframework.web.authorization.oauth2.client.request.definition.ResponseJudgeForServerIdDefinition;
import org.hswebframework.web.authorization.oauth2.client.simple.request.builder.SimpleOAuth2RequestBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SimpleOAuth2RequestBuilderFactory
implements OAuth2RequestBuilderFactory,
BeanPostProcessor {
    private final Map<String, ResponseJudge> judgeMap = new HashMap<String, ResponseJudge>();
    private final Map<String, ResponseConvertHandler> convertHandlerMap = new HashMap<String, ResponseConvertHandler>();
    ResponseConvertHandler defaultConvertHandler;
    ResponseJudge defaultResponseJudge;
    RequestBuilder requestBuilder;

    public void setRequestBuilder(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    public RequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void setJudgeForServerId(String serverId, ResponseJudge judge) {
        this.judgeMap.put("serverId:" + serverId, judge);
    }

    public void setConvertForServerId(String serverId, ResponseConvertHandler convertHandler) {
        this.convertHandlerMap.put("serverId:" + serverId, convertHandler);
    }

    public void setJudgeForProvider(String serverId, ResponseJudge judge) {
        this.judgeMap.put("provider:" + serverId, judge);
    }

    public void setConvertForProvider(String serverId, ResponseConvertHandler convertHandler) {
        this.convertHandlerMap.put("provider:" + serverId, convertHandler);
    }

    public void setDefaultConvertHandler(ResponseConvertHandler defaultConvertHandler) {
        this.defaultConvertHandler = defaultConvertHandler;
    }

    public void setDefaultResponseJudge(ResponseJudge defaultResponseJudge) {
        this.defaultResponseJudge = defaultResponseJudge;
    }

    protected ResponseConvertHandler getConvertHandler(String id, String provider) {
        ResponseConvertHandler convertHandler = this.convertHandlerMap.get("serverId:" + id);
        if (convertHandler == null) {
            convertHandler = this.convertHandlerMap.getOrDefault("provider:" + provider, this.defaultConvertHandler);
        }
        return convertHandler;
    }

    protected ResponseJudge getResponseJudge(String id, String provider) {
        ResponseJudge judge = this.judgeMap.get("serverId:" + id);
        if (judge == null) {
            judge = this.judgeMap.getOrDefault("provider:" + provider, this.defaultResponseJudge);
        }
        return judge;
    }

    @Override
    public OAuth2RequestBuilder create(String serverId, String provider) {
        SimpleOAuth2RequestBuilder builder = new SimpleOAuth2RequestBuilder();
        builder.requestBuilder(this.getRequestBuilder()).convertHandler(this.getConvertHandler(serverId, provider)).responseJudge(this.getResponseJudge(serverId, provider));
        return builder;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object definition;
        if (bean instanceof ResponseJudgeForServerIdDefinition) {
            definition = (ResponseJudgeForServerIdDefinition)bean;
            this.setJudgeForServerId(definition.getServerId(), (ResponseJudge)definition);
        }
        if (bean instanceof ResponseConvertForServerIdDefinition) {
            definition = (ResponseConvertForServerIdDefinition)bean;
            this.setConvertForServerId(definition.getServerId(), (ResponseConvertHandler)definition);
        }
        if (bean instanceof ResponseJudgeForProviderDefinition) {
            definition = (ResponseJudgeForProviderDefinition)bean;
            this.setJudgeForProvider(definition.getProvider(), (ResponseJudge)definition);
        }
        if (bean instanceof ResponseConvertForProviderDefinition) {
            definition = (ResponseConvertForProviderDefinition)bean;
            this.setConvertForProvider(definition.getProvider(), (ResponseConvertHandler)definition);
        }
        return bean;
    }
}

